/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.spark.util;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.amoro.TableFormat;
import org.apache.amoro.shade.guava32.com.google.common.base.Joiner;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.spark.table.MixedSparkTable;
import org.apache.amoro.table.DistributionHashMode;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.table.PrimaryKeySpec;
import org.apache.avro.generic.GenericData;
import org.apache.avro.util.Utf8;
import org.apache.iceberg.DistributionMode;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.util.ByteBuffers;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.distributions.ClusteredDistribution;
import org.apache.spark.sql.connector.distributions.Distributions;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.Expressions;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MixedFormatSparkUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MixedFormatSparkUtils.class);

    public static TableCatalogAndIdentifier tableCatalogAndIdentifier(SparkSession spark, List<String> nameParts) {
        Spark3Util.CatalogAndIdentifier catalogAndIdentifier = Spark3Util.catalogAndIdentifier((SparkSession)spark, nameParts, (CatalogPlugin)spark.sessionState().catalogManager().currentCatalog());
        CatalogPlugin catalog = catalogAndIdentifier.catalog();
        Preconditions.checkArgument((boolean)(catalog instanceof TableCatalog), (String)"Cannot resolver name-parts %s to catalog and identifier, %s is not a table catalog", (Object)Joiner.on((char)',').join(nameParts), (Object)catalog.name());
        return new TableCatalogAndIdentifier((TableCatalog)catalog, catalogAndIdentifier.identifier());
    }

    public static ClusteredDistribution buildRequiredDistribution(MixedSparkTable mixedSparkTable) {
        String modeName = PropertyUtil.propertyAsString(mixedSparkTable.properties(), (String)"write.distribution-mode", (String)"hash");
        DistributionMode writeMode = DistributionMode.fromName((String)modeName);
        switch (writeMode) {
            case NONE: {
                return null;
            }
            case HASH: {
                DistributionHashMode distributionHashMode = DistributionHashMode.valueOfDesc((String)mixedSparkTable.properties().getOrDefault("write.distribution.hash-mode", "auto"));
                ArrayList<Transform> transforms = new ArrayList<Transform>();
                if (DistributionHashMode.AUTO.equals((Object)distributionHashMode)) {
                    distributionHashMode = DistributionHashMode.autoSelect((boolean)mixedSparkTable.table().isKeyedTable(), (!mixedSparkTable.table().spec().isUnpartitioned() ? 1 : 0) != 0);
                }
                if (distributionHashMode.isSupportPrimaryKey()) {
                    Transform transform = MixedFormatSparkUtils.toTransformsFromPrimary(mixedSparkTable, mixedSparkTable.table().asKeyedTable().primaryKeySpec());
                    transforms.add(transform);
                    if (distributionHashMode.isSupportPartition()) {
                        transforms.addAll(Arrays.asList(Spark3Util.toTransforms((PartitionSpec)mixedSparkTable.table().spec())));
                    }
                    return Distributions.clustered((Expression[])((Expression[])transforms.stream().filter(Objects::nonNull).toArray(Transform[]::new)));
                }
                if (distributionHashMode.isSupportPartition()) {
                    return Distributions.clustered((Expression[])Spark3Util.toTransforms((PartitionSpec)mixedSparkTable.table().spec()));
                }
                return null;
            }
            case RANGE: {
                LOG.warn("Fallback to use 'none' distribution mode, because {}={} is not supported in spark now", (Object)"write.distribution-mode", (Object)DistributionMode.RANGE.modeName());
                return null;
            }
        }
        throw new RuntimeException("Unrecognized write.distribution-mode: " + writeMode);
    }

    private static Transform toTransformsFromPrimary(MixedSparkTable mixedSparkTable, PrimaryKeySpec primaryKeySpec) {
        int numBucket = PropertyUtil.propertyAsInt(mixedSparkTable.properties(), (String)"base.file-index.hash-bucket", (int)4);
        return Expressions.bucket((int)numBucket, (String[])new String[]{(String)primaryKeySpec.fieldNames().get(0)});
    }

    public static Object convertConstant(Type type, Object value) {
        if (value == null) {
            return null;
        }
        switch (type.typeId()) {
            case DECIMAL: {
                return Decimal.apply((BigDecimal)((BigDecimal)value));
            }
            case STRING: {
                if (value instanceof Utf8) {
                    Utf8 utf8 = (Utf8)value;
                    return UTF8String.fromBytes((byte[])utf8.getBytes(), (int)0, (int)utf8.getByteLength());
                }
                return UTF8String.fromString((String)value.toString());
            }
            case FIXED: {
                if (value instanceof byte[]) {
                    return value;
                }
                if (value instanceof GenericData.Fixed) {
                    return ((GenericData.Fixed)value).bytes();
                }
                return ByteBuffers.toByteArray((ByteBuffer)((ByteBuffer)value));
            }
            case BINARY: {
                return ByteBuffers.toByteArray((ByteBuffer)((ByteBuffer)value));
            }
        }
        return value;
    }

    public static String mixedTableProvider(MixedTable table) {
        if (table.format().in(new TableFormat[]{TableFormat.MIXED_HIVE, TableFormat.MIXED_ICEBERG})) {
            return table.format().name().toLowerCase(Locale.ROOT);
        }
        throw new IllegalArgumentException("Not a mixed-format table:" + table.format());
    }

    public static class TableCatalogAndIdentifier {
        TableCatalog tableCatalog;
        Identifier identifier;

        public TableCatalogAndIdentifier(TableCatalog tableCatalog, Identifier identifier) {
            this.tableCatalog = tableCatalog;
            this.identifier = identifier;
        }

        public TableCatalog catalog() {
            return this.tableCatalog;
        }

        public Identifier identifier() {
            return this.identifier;
        }
    }
}

