/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3BucketSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3BucketSource> {
    private static final SdkField<String> S3_BUCKET_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BucketOwner").getter(S3BucketSource.getter(S3BucketSource::s3BucketOwner)).setter(S3BucketSource.setter(Builder::s3BucketOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketOwner").build()}).build();
    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Bucket").getter(S3BucketSource.getter(S3BucketSource::s3Bucket)).setter(S3BucketSource.setter(Builder::s3Bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Bucket").build()}).build();
    private static final SdkField<String> S3_KEY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3KeyPrefix").getter(S3BucketSource.getter(S3BucketSource::s3KeyPrefix)).setter(S3BucketSource.setter(Builder::s3KeyPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3KeyPrefix").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_OWNER_FIELD, S3_BUCKET_FIELD, S3_KEY_PREFIX_FIELD));
    private static final long serialVersionUID = 1L;
    private final String s3BucketOwner;
    private final String s3Bucket;
    private final String s3KeyPrefix;

    private S3BucketSource(BuilderImpl builder) {
        this.s3BucketOwner = builder.s3BucketOwner;
        this.s3Bucket = builder.s3Bucket;
        this.s3KeyPrefix = builder.s3KeyPrefix;
    }

    public final String s3BucketOwner() {
        return this.s3BucketOwner;
    }

    public final String s3Bucket() {
        return this.s3Bucket;
    }

    public final String s3KeyPrefix() {
        return this.s3KeyPrefix;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3KeyPrefix());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3BucketSource)) {
            return false;
        }
        S3BucketSource other = (S3BucketSource)obj;
        return Objects.equals(this.s3BucketOwner(), other.s3BucketOwner()) && Objects.equals(this.s3Bucket(), other.s3Bucket()) && Objects.equals(this.s3KeyPrefix(), other.s3KeyPrefix());
    }

    public final String toString() {
        return ToString.builder((String)"S3BucketSource").add("S3BucketOwner", (Object)this.s3BucketOwner()).add("S3Bucket", (Object)this.s3Bucket()).add("S3KeyPrefix", (Object)this.s3KeyPrefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3BucketOwner": {
                return Optional.ofNullable(clazz.cast(this.s3BucketOwner()));
            }
            case "S3Bucket": {
                return Optional.ofNullable(clazz.cast(this.s3Bucket()));
            }
            case "S3KeyPrefix": {
                return Optional.ofNullable(clazz.cast(this.s3KeyPrefix()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3BucketSource, T> g) {
        return obj -> g.apply((S3BucketSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3BucketOwner;
        private String s3Bucket;
        private String s3KeyPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(S3BucketSource model) {
            this.s3BucketOwner(model.s3BucketOwner);
            this.s3Bucket(model.s3Bucket);
            this.s3KeyPrefix(model.s3KeyPrefix);
        }

        public final String getS3BucketOwner() {
            return this.s3BucketOwner;
        }

        public final void setS3BucketOwner(String s3BucketOwner) {
            this.s3BucketOwner = s3BucketOwner;
        }

        @Override
        public final Builder s3BucketOwner(String s3BucketOwner) {
            this.s3BucketOwner = s3BucketOwner;
            return this;
        }

        public final String getS3Bucket() {
            return this.s3Bucket;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final String getS3KeyPrefix() {
            return this.s3KeyPrefix;
        }

        public final void setS3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
        }

        @Override
        public final Builder s3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        public S3BucketSource build() {
            return new S3BucketSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3BucketSource> {
        public Builder s3BucketOwner(String var1);

        public Builder s3Bucket(String var1);

        public Builder s3KeyPrefix(String var1);
    }
}

