/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.util.Map;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;

public class SparkTableCache {
    private static final SparkTableCache INSTANCE = new SparkTableCache();
    private final Map<String, Table> cache = Maps.newConcurrentMap();

    public static SparkTableCache get() {
        return INSTANCE;
    }

    public int size() {
        return this.cache.size();
    }

    public void add(String key, Table table) {
        this.cache.put(key, table);
    }

    public boolean contains(String key) {
        return this.cache.containsKey(key);
    }

    public Table get(String key) {
        return this.cache.get(key);
    }

    public Table remove(String key) {
        return this.cache.remove(key);
    }
}

