/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.BaseMetadataTable;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFiles;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Partitioning;
import org.apache.iceberg.PositionDeletesTable;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Evaluator;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ExpressionUtil;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Projections;
import org.apache.iceberg.expressions.StrictMetricsEvaluator;
import org.apache.iceberg.expressions.True;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.spark.CommitMetadata;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.spark.SparkFilters;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.SparkTableUtil;
import org.apache.iceberg.spark.SparkUtil;
import org.apache.iceberg.spark.source.SparkMetadataColumn;
import org.apache.iceberg.spark.source.SparkPositionDeletesRewriteBuilder;
import org.apache.iceberg.spark.source.SparkRowLevelOperationBuilder;
import org.apache.iceberg.spark.source.SparkScanBuilder;
import org.apache.iceberg.spark.source.SparkStagedScanBuilder;
import org.apache.iceberg.spark.source.SparkWriteBuilder;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.SnapshotUtil;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connector.catalog.MetadataColumn;
import org.apache.spark.sql.connector.catalog.SupportsDelete;
import org.apache.spark.sql.connector.catalog.SupportsMetadataColumns;
import org.apache.spark.sql.connector.catalog.SupportsRead;
import org.apache.spark.sql.connector.catalog.SupportsRowLevelOperations;
import org.apache.spark.sql.connector.catalog.SupportsWrite;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.connector.write.LogicalWriteInfo;
import org.apache.spark.sql.connector.write.RowLevelOperationBuilder;
import org.apache.spark.sql.connector.write.RowLevelOperationInfo;
import org.apache.spark.sql.connector.write.WriteBuilder;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkTable
implements org.apache.spark.sql.connector.catalog.Table,
SupportsRead,
SupportsWrite,
SupportsDelete,
SupportsRowLevelOperations,
SupportsMetadataColumns {
    private static final Logger LOG = LoggerFactory.getLogger(SparkTable.class);
    private static final Set<String> RESERVED_PROPERTIES = ImmutableSet.of((Object)"provider", (Object)"format", (Object)"current-snapshot-id", (Object)"location", (Object)"format-version", (Object)"sort-order", (Object[])new String[]{"identifier-fields"});
    private static final Set<TableCapability> CAPABILITIES = ImmutableSet.of((Object)TableCapability.BATCH_READ, (Object)TableCapability.BATCH_WRITE, (Object)TableCapability.MICRO_BATCH_READ, (Object)TableCapability.STREAMING_WRITE, (Object)TableCapability.OVERWRITE_BY_FILTER, (Object)TableCapability.OVERWRITE_DYNAMIC, (Object[])new TableCapability[0]);
    private static final Set<TableCapability> CAPABILITIES_WITH_ACCEPT_ANY_SCHEMA = ImmutableSet.builder().addAll(CAPABILITIES).add((Object)TableCapability.ACCEPT_ANY_SCHEMA).build();
    private final Table icebergTable;
    private final Long snapshotId;
    private final boolean refreshEagerly;
    private final Set<TableCapability> capabilities;
    private String branch;
    private StructType lazyTableSchema = null;
    private SparkSession lazySpark = null;

    public SparkTable(Table icebergTable, boolean refreshEagerly) {
        this(icebergTable, (Long)null, refreshEagerly);
    }

    public SparkTable(Table icebergTable, String branch, boolean refreshEagerly) {
        this(icebergTable, refreshEagerly);
        this.branch = branch;
        ValidationException.check((branch == null || "main".equals(branch) || icebergTable.snapshot(branch) != null ? 1 : 0) != 0, (String)"Cannot use branch (does not exist): %s", (Object[])new Object[]{branch});
    }

    public SparkTable(Table icebergTable, Long snapshotId, boolean refreshEagerly) {
        this.icebergTable = icebergTable;
        this.snapshotId = snapshotId;
        this.refreshEagerly = refreshEagerly;
        boolean acceptAnySchema = PropertyUtil.propertyAsBoolean((Map)icebergTable.properties(), (String)"write.spark.accept-any-schema", (boolean)false);
        this.capabilities = acceptAnySchema ? CAPABILITIES_WITH_ACCEPT_ANY_SCHEMA : CAPABILITIES;
    }

    private SparkSession sparkSession() {
        if (this.lazySpark == null) {
            this.lazySpark = SparkSession.active();
        }
        return this.lazySpark;
    }

    public Table table() {
        return this.icebergTable;
    }

    public String name() {
        return this.icebergTable.toString();
    }

    public Long snapshotId() {
        return this.snapshotId;
    }

    public String branch() {
        return this.branch;
    }

    public SparkTable copyWithSnapshotId(long newSnapshotId) {
        return new SparkTable(this.icebergTable, newSnapshotId, this.refreshEagerly);
    }

    public SparkTable copyWithBranch(String targetBranch) {
        return new SparkTable(this.icebergTable, targetBranch, this.refreshEagerly);
    }

    private Schema snapshotSchema() {
        if (this.icebergTable instanceof BaseMetadataTable) {
            return this.icebergTable.schema();
        }
        if (this.branch != null) {
            return SnapshotUtil.schemaFor((Table)this.icebergTable, (String)this.branch);
        }
        return SnapshotUtil.schemaFor((Table)this.icebergTable, (Long)this.snapshotId, null);
    }

    public StructType schema() {
        if (this.lazyTableSchema == null) {
            this.lazyTableSchema = SparkSchemaUtil.convert(this.snapshotSchema());
        }
        return this.lazyTableSchema;
    }

    public Transform[] partitioning() {
        return Spark3Util.toTransforms(this.icebergTable.spec());
    }

    public Map<String, String> properties() {
        Set identifierFields;
        ImmutableMap.Builder propsBuilder = ImmutableMap.builder();
        String fileFormat = this.icebergTable.properties().getOrDefault("write.format.default", "parquet");
        propsBuilder.put((Object)"format", (Object)("iceberg/" + fileFormat));
        propsBuilder.put((Object)"provider", (Object)"iceberg");
        String currentSnapshotId = this.icebergTable.currentSnapshot() != null ? String.valueOf(this.icebergTable.currentSnapshot().snapshotId()) : "none";
        propsBuilder.put((Object)"current-snapshot-id", (Object)currentSnapshotId);
        propsBuilder.put((Object)"location", (Object)this.icebergTable.location());
        if (this.icebergTable instanceof BaseTable) {
            TableOperations ops = ((BaseTable)this.icebergTable).operations();
            propsBuilder.put((Object)"format-version", (Object)String.valueOf(ops.current().formatVersion()));
        }
        if (!this.icebergTable.sortOrder().isUnsorted()) {
            propsBuilder.put((Object)"sort-order", (Object)Spark3Util.describe(this.icebergTable.sortOrder()));
        }
        if (!(identifierFields = this.icebergTable.schema().identifierFieldNames()).isEmpty()) {
            propsBuilder.put((Object)"identifier-fields", (Object)("[" + String.join((CharSequence)",", identifierFields) + "]"));
        }
        this.icebergTable.properties().entrySet().stream().filter(entry -> !RESERVED_PROPERTIES.contains(entry.getKey())).forEach(arg_0 -> ((ImmutableMap.Builder)propsBuilder).put(arg_0));
        return propsBuilder.build();
    }

    public Set<TableCapability> capabilities() {
        return this.capabilities;
    }

    public MetadataColumn[] metadataColumns() {
        DataType sparkPartitionType = SparkSchemaUtil.convert((Type)Partitioning.partitionType((Table)this.table()));
        return new MetadataColumn[]{new SparkMetadataColumn(MetadataColumns.SPEC_ID.name(), DataTypes.IntegerType, false), new SparkMetadataColumn("_partition", sparkPartitionType, true), new SparkMetadataColumn(MetadataColumns.FILE_PATH.name(), DataTypes.StringType, false), new SparkMetadataColumn(MetadataColumns.ROW_POSITION.name(), DataTypes.LongType, false), new SparkMetadataColumn(MetadataColumns.IS_DELETED.name(), DataTypes.BooleanType, false)};
    }

    public ScanBuilder newScanBuilder(CaseInsensitiveStringMap options) {
        if (options.containsKey((Object)"scan-task-set-id")) {
            return new SparkStagedScanBuilder(this.sparkSession(), this.icebergTable, options);
        }
        if (this.refreshEagerly) {
            this.icebergTable.refresh();
        }
        CaseInsensitiveStringMap scanOptions = this.branch != null ? options : SparkTable.addSnapshotId(options, this.snapshotId);
        return new SparkScanBuilder(this.sparkSession(), this.icebergTable, this.branch, this.snapshotSchema(), scanOptions);
    }

    public WriteBuilder newWriteBuilder(LogicalWriteInfo info) {
        Preconditions.checkArgument((this.snapshotId == null ? 1 : 0) != 0, (String)"Cannot write to table at a specific snapshot: %s", (Object)this.snapshotId);
        if (this.icebergTable instanceof PositionDeletesTable) {
            return new SparkPositionDeletesRewriteBuilder(this.sparkSession(), this.icebergTable, this.branch, info);
        }
        return new SparkWriteBuilder(this.sparkSession(), this.icebergTable, this.branch, info);
    }

    public RowLevelOperationBuilder newRowLevelOperationBuilder(RowLevelOperationInfo info) {
        return new SparkRowLevelOperationBuilder(this.sparkSession(), this.icebergTable, this.branch, info);
    }

    public boolean canDeleteWhere(Filter[] filters) {
        Preconditions.checkArgument((this.snapshotId == null ? 1 : 0) != 0, (String)"Cannot delete from table at a specific snapshot: %s", (Object)this.snapshotId);
        True deleteExpr = Expressions.alwaysTrue();
        for (Filter filter : filters) {
            Expression expr = SparkFilters.convert(filter);
            if (expr == null) {
                return false;
            }
            deleteExpr = Expressions.and((Expression)deleteExpr, (Expression)expr);
        }
        return this.canDeleteUsingMetadata((Expression)deleteExpr);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean canDeleteUsingMetadata(Expression deleteExpr) {
        boolean caseSensitive = SparkUtil.caseSensitive(this.sparkSession());
        if (ExpressionUtil.selectsPartitions((Expression)deleteExpr, (Table)this.table(), (boolean)caseSensitive)) {
            return true;
        }
        TableScan scan = (TableScan)((TableScan)((TableScan)((TableScan)this.table().newScan().filter(deleteExpr)).caseSensitive(caseSensitive)).includeColumnStats()).ignoreResiduals();
        if (this.branch != null) {
            scan = scan.useRef(this.branch);
        }
        try (CloseableIterable tasks = scan.planFiles();){
            HashMap evaluators = Maps.newHashMap();
            StrictMetricsEvaluator metricsEvaluator = new StrictMetricsEvaluator(SnapshotUtil.schemaFor((Table)this.table(), (String)this.branch), deleteExpr);
            boolean bl = Iterables.all((Iterable)tasks, task -> {
                DataFile file = (DataFile)task.file();
                PartitionSpec spec = task.spec();
                Evaluator evaluator = evaluators.computeIfAbsent(spec.specId(), specId -> new Evaluator(spec.partitionType(), Projections.strict((PartitionSpec)spec).project(deleteExpr)));
                return evaluator.eval(file.partition()) || metricsEvaluator.eval((ContentFile)file);
            });
            return bl;
        }
        catch (IOException ioe) {
            LOG.warn("Failed to close task iterable", (Throwable)ioe);
            return false;
        }
    }

    public void deleteWhere(Filter[] filters) {
        Expression deleteExpr = SparkFilters.convert(filters);
        if (deleteExpr == Expressions.alwaysFalse()) {
            LOG.info("Skipping the delete operation as the condition is always false");
            return;
        }
        DeleteFiles deleteFiles = ((DeleteFiles)this.icebergTable.newDelete().set("spark.app.id", this.sparkSession().sparkContext().applicationId())).deleteFromRowFilter(deleteExpr);
        if (SparkTableUtil.wapEnabled(this.table())) {
            this.branch = SparkTableUtil.determineWriteBranch(this.sparkSession(), this.branch);
        }
        if (this.branch != null) {
            deleteFiles.toBranch(this.branch);
        }
        if (!CommitMetadata.commitProperties().isEmpty()) {
            CommitMetadata.commitProperties().forEach((arg_0, arg_1) -> ((DeleteFiles)deleteFiles).set(arg_0, arg_1));
        }
        deleteFiles.commit();
    }

    public String toString() {
        return this.icebergTable.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SparkTable that = (SparkTable)other;
        return this.icebergTable.name().equals(that.icebergTable.name());
    }

    public int hashCode() {
        return this.icebergTable.name().hashCode();
    }

    private static CaseInsensitiveStringMap addSnapshotId(CaseInsensitiveStringMap options, Long snapshotId) {
        if (snapshotId != null) {
            String snapshotIdFromOptions = options.get((Object)"snapshot-id");
            String value = snapshotId.toString();
            Preconditions.checkArgument((snapshotIdFromOptions == null || snapshotIdFromOptions.equals(value) ? 1 : 0) != 0, (String)"Cannot override snapshot ID more than once: %s", (Object)snapshotIdFromOptions);
            HashMap scanOptions = Maps.newHashMap();
            scanOptions.putAll(options.asCaseSensitiveMap());
            scanOptions.put("snapshot-id", value);
            scanOptions.remove("as-of-timestamp");
            scanOptions.remove("branch");
            scanOptions.remove("tag");
            return new CaseInsensitiveStringMap((Map)scanOptions);
        }
        return options;
    }
}

