/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.service;

import io.grpc.stub.StreamObserver;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.bifromq.baserpc.server.UnaryResponse;
import org.apache.bifromq.mqtt.inbox.rpc.proto.BrokerServiceGrpc;
import org.apache.bifromq.mqtt.inbox.rpc.proto.InboxStateReply;
import org.apache.bifromq.mqtt.inbox.rpc.proto.InboxStateRequest;
import org.apache.bifromq.mqtt.inbox.rpc.proto.SubReply;
import org.apache.bifromq.mqtt.inbox.rpc.proto.SubRequest;
import org.apache.bifromq.mqtt.inbox.rpc.proto.UnsubReply;
import org.apache.bifromq.mqtt.inbox.rpc.proto.UnsubRequest;
import org.apache.bifromq.mqtt.inbox.rpc.proto.WriteReply;
import org.apache.bifromq.mqtt.inbox.rpc.proto.WriteRequest;
import org.apache.bifromq.mqtt.service.ILocalDistService;
import org.apache.bifromq.mqtt.service.ILocalSessionRegistry;
import org.apache.bifromq.mqtt.service.LocalSessionWritePipeline;
import org.apache.bifromq.mqtt.session.IMQTTSession;
import org.apache.bifromq.mqtt.session.IMQTTTransientSession;
import org.apache.bifromq.plugin.subbroker.CheckReply;
import org.apache.bifromq.plugin.subbroker.CheckRequest;
import org.apache.bifromq.type.MatchInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LocalSessionBrokerService
extends BrokerServiceGrpc.BrokerServiceImplBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalSessionBrokerService.class);
    private final ILocalSessionRegistry localSessionRegistry;
    private final ILocalDistService localDistService;

    public LocalSessionBrokerService(ILocalSessionRegistry registry, ILocalDistService service) {
        this.localSessionRegistry = registry;
        this.localDistService = service;
    }

    public void state(InboxStateRequest request, StreamObserver<InboxStateReply> responseObserver) {
        UnaryResponse.response(tenantId -> {
            IMQTTSession session = this.localSessionRegistry.get(request.getSessionId());
            if (session instanceof IMQTTTransientSession) {
                IMQTTTransientSession transientSession = (IMQTTTransientSession)session;
                return CompletableFuture.completedFuture(InboxStateReply.newBuilder().setReqId(request.getReqId()).setCode(InboxStateReply.Code.OK).setState(transientSession.inboxState()).build());
            }
            return CompletableFuture.completedFuture(InboxStateReply.newBuilder().setReqId(request.getReqId()).setCode(InboxStateReply.Code.NO_INBOX).build());
        }, responseObserver);
    }

    public StreamObserver<WriteRequest> write(StreamObserver<WriteReply> responseObserver) {
        return new LocalSessionWritePipeline(this.localDistService, responseObserver);
    }

    public void sub(SubRequest request, StreamObserver<SubReply> responseObserver) {
        UnaryResponse.response(tenantId -> {
            IMQTTSession session = this.localSessionRegistry.get(request.getSessionId());
            if (session != null) {
                SubReply.Builder builder = SubReply.newBuilder();
                builder.setReqId(request.getReqId());
                return session.subscribe(request.getReqId(), request.getTopicFilter(), request.getSubQoS()).thenApply(v -> SubReply.newBuilder().setReqId(request.getReqId()).setResult(v).build());
            }
            return CompletableFuture.completedFuture(SubReply.newBuilder().setReqId(request.getReqId()).setResult(SubReply.Result.NO_INBOX).build());
        }, responseObserver);
    }

    public void unsub(UnsubRequest request, StreamObserver<UnsubReply> responseObserver) {
        UnaryResponse.response(tenantId -> {
            IMQTTSession session = this.localSessionRegistry.get(request.getSessionId());
            if (session != null) {
                return session.unsubscribe(request.getReqId(), request.getTopicFilter()).thenApply(v -> UnsubReply.newBuilder().setReqId(request.getReqId()).setResult(v).build());
            }
            return CompletableFuture.completedFuture(UnsubReply.newBuilder().setReqId(request.getReqId()).setResult(UnsubReply.Result.NO_INBOX).build());
        }, responseObserver);
    }

    public void checkSubscriptions(CheckRequest request, StreamObserver<CheckReply> responseObserver) {
        UnaryResponse.response(ignore -> {
            CheckReply.Builder replyBuilder = CheckReply.newBuilder();
            for (MatchInfo matchInfo : request.getMatchInfoList()) {
                CheckReply.Code code = this.localDistService.checkMatchInfo(request.getTenantId(), matchInfo);
                replyBuilder.addCode(code);
            }
            return CompletableFuture.completedFuture(replyBuilder.build());
        }, responseObserver);
    }
}

