/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.deliverer;

import org.apache.bifromq.basescheduler.IBatchCall;
import org.apache.bifromq.basescheduler.IBatchCallBuilder;
import org.apache.bifromq.basescheduler.IBatchCallBuilderFactory;
import org.apache.bifromq.deliverer.BatchDeliveryCall;
import org.apache.bifromq.deliverer.DelivererKey;
import org.apache.bifromq.deliverer.DeliveryCall;
import org.apache.bifromq.deliverer.DeliveryCallResult;
import org.apache.bifromq.dist.client.IDistClient;
import org.apache.bifromq.plugin.subbroker.IDeliverer;
import org.apache.bifromq.plugin.subbroker.ISubBrokerManager;

public class BatchDeliveryCallBuilderFactory
implements IBatchCallBuilderFactory<DeliveryCall, DeliveryCallResult, DelivererKey> {
    private final IDistClient distClient;
    private final ISubBrokerManager subBrokerManager;

    public BatchDeliveryCallBuilderFactory(IDistClient distClient, ISubBrokerManager subBrokerManager) {
        this.distClient = distClient;
        this.subBrokerManager = subBrokerManager;
    }

    public IBatchCallBuilder<DeliveryCall, DeliveryCallResult, DelivererKey> newBuilder(String name, final DelivererKey batcherKey) {
        int brokerId = batcherKey.subBrokerId();
        final IDeliverer deliverer = this.subBrokerManager.get(brokerId).open(batcherKey.delivererKey());
        return new IBatchCallBuilder<DeliveryCall, DeliveryCallResult, DelivererKey>(){

            public IBatchCall<DeliveryCall, DeliveryCallResult, DelivererKey> newBatchCall() {
                return new BatchDeliveryCall(BatchDeliveryCallBuilderFactory.this.distClient, deliverer, batcherKey);
            }

            public void close() {
                deliverer.close();
            }
        };
    }
}

