/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.localengine.rocksdb;

import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import com.google.protobuf.Struct;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.bifromq.baseenv.EnvProvider;
import org.apache.bifromq.basekv.localengine.AbstractKVSpace;
import org.apache.bifromq.basekv.localengine.ISyncContext;
import org.apache.bifromq.basekv.localengine.StructUtil;
import org.apache.bifromq.basekv.localengine.SyncContext;
import org.apache.bifromq.basekv.localengine.metrics.IKVSpaceMetric;
import org.apache.bifromq.basekv.localengine.metrics.KVSpaceMeters;
import org.apache.bifromq.basekv.localengine.metrics.KVSpaceOpMeters;
import org.apache.bifromq.basekv.localengine.rocksdb.IWriteStatsRecorder;
import org.apache.bifromq.basekv.localengine.rocksdb.NoopWriteStatsRecorder;
import org.apache.bifromq.basekv.localengine.rocksdb.RocksDBHelper;
import org.apache.bifromq.basekv.localengine.rocksdb.RocksDBKVEngine;
import org.apache.bifromq.basekv.localengine.rocksdb.RocksDBKVSpaceCompactionTrigger;
import org.apache.bifromq.basekv.localengine.rocksdb.RocksDBKVSpaceEpochHandle;
import org.apache.bifromq.basekv.localengine.rocksdb.metrics.RocksDBKVSpaceMetric;
import org.apache.bifromq.basekv.proto.Boundary;
import org.rocksdb.CompactRangeOptions;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;

abstract class RocksDBKVSpace
extends AbstractKVSpace<RocksDBKVSpaceEpochHandle> {
    protected final Struct conf;
    protected final RocksDBKVEngine<?> engine;
    protected final ISyncContext syncContext;
    protected final IWriteStatsRecorder writeStats;
    private final File keySpaceDBDir;
    private final ExecutorService compactionExecutor;
    private final AtomicBoolean compacting;
    private final ISyncContext.IRefresher metadataRefresher;
    private SpaceMetrics spaceMetrics;
    private volatile long lastCompactAt;
    private volatile long nextCompactAt;

    public RocksDBKVSpace(String id, Struct conf, RocksDBKVEngine<?> engine, Runnable onDestroy, KVSpaceOpMeters opMeters, Logger logger, String ... tags) {
        super(id, onDestroy, opMeters, logger, tags);
        this.conf = conf;
        this.engine = engine;
        this.syncContext = new SyncContext();
        this.metadataRefresher = this.syncContext.refresher();
        this.compacting = new AtomicBoolean(false);
        this.compactionExecutor = ExecutorServiceMetrics.monitor((MeterRegistry)Metrics.globalRegistry, (ExecutorService)new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), EnvProvider.INSTANCE.newThreadFactory("kvspace-compactor-" + id)), (String)"compactor", (String)"kvspace", (Iterable)Tags.of((String[])tags));
        if (StructUtil.boolVal((Struct)conf, (String)"manualCompaction")) {
            int minKeys = (int)StructUtil.numVal((Struct)conf, (String)"compactMinTombstoneKeys");
            int minRanges = (int)StructUtil.numVal((Struct)conf, (String)"compactMinTombstoneRanges");
            double ratio = StructUtil.numVal((Struct)conf, (String)"compactTombstoneRatio");
            this.writeStats = new RocksDBKVSpaceCompactionTrigger(id, minKeys, minRanges, ratio, this::scheduleCompact, tags);
        } else {
            this.writeStats = NoopWriteStatsRecorder.INSTANCE;
        }
        this.keySpaceDBDir = new File(StructUtil.strVal((Struct)conf, (String)"dbRootDir"), id);
    }

    protected void doOpen() {
        this.spaceMetrics = new SpaceMetrics(this.tags);
        this.reloadMetadata();
    }

    protected void reloadMetadata() {
        this.updateMetadata(RocksDBHelper.getMetadata(this.handle()));
    }

    protected void publishMetadata(Map<ByteString, ByteString> metadataUpdates) {
        if (metadataUpdates.isEmpty()) {
            return;
        }
        this.metadataRefresher.runIfNeeded(genBumped -> {
            HashMap metaMap = Maps.newHashMap((Map)this.currentMetadata());
            metaMap.putAll(metadataUpdates);
            this.updateMetadata(Collections.unmodifiableMap(metaMap));
        });
    }

    protected void doClose() {
        this.logger.debug("Close key range[{}]", (Object)this.id);
        if (this.spaceMetrics != null) {
            this.spaceMetrics.close();
        }
    }

    protected void doDestroy() {
        try {
            if (this.keySpaceDBDir.exists()) {
                RocksDBHelper.deleteDir(this.keySpaceDBDir.toPath());
            }
        }
        catch (IOException e) {
            this.logger.error("Failed to delete space root dir: {}", (Object)this.keySpaceDBDir, (Object)e);
        }
    }

    protected File spaceRootDir() {
        return this.keySpaceDBDir;
    }

    protected abstract RocksDBKVSpaceEpochHandle handle();

    protected abstract WriteOptions writeOptions();

    private void scheduleCompact() {
        if (this.state() != AbstractKVSpace.State.Opening) {
            return;
        }
        this.spaceMetrics.compactionSchedCounter.increment();
        if (this.compacting.compareAndSet(false, true)) {
            this.compactionExecutor.execute(this.spaceMetrics.compactionTimer.wrap(() -> {
                this.logger.debug("KeyRange[{}] compaction start", (Object)this.id);
                this.lastCompactAt = System.nanoTime();
                this.writeStats.reset();
                try (CompactRangeOptions options = new CompactRangeOptions().setBottommostLevelCompaction(CompactRangeOptions.BottommostLevelCompaction.kSkip).setExclusiveManualCompaction(false);){
                    AtomicBoolean atomicBoolean = this.compacting;
                    synchronized (atomicBoolean) {
                        if (this.state() == AbstractKVSpace.State.Opening) {
                            RocksDBKVSpaceEpochHandle handle = this.handle();
                            handle.db().compactRange(handle.cf(), null, null, options);
                        }
                    }
                    this.logger.debug("KeyRange[{}] compacted", (Object)this.id);
                }
                catch (Throwable e) {
                    this.logger.error("KeyRange[{}] compaction error", (Object)this.id, (Object)e);
                }
                finally {
                    this.compacting.set(false);
                    if (this.nextCompactAt > this.lastCompactAt) {
                        this.scheduleCompact();
                    }
                }
            }));
        } else {
            this.nextCompactAt = System.nanoTime();
        }
    }

    protected long doSize(Boundary boundary) {
        if (this.state() != AbstractKVSpace.State.Opening) {
            return 0L;
        }
        return RocksDBHelper.sizeOfBoundary(this.handle(), boundary);
    }

    private class SpaceMetrics {
        private final Counter compactionSchedCounter;
        private final Timer compactionTimer;

        SpaceMetrics(Tags metricTags) {
            this.compactionSchedCounter = KVSpaceMeters.getCounter((String)RocksDBKVSpace.this.id, (IKVSpaceMetric)RocksDBKVSpaceMetric.ManualCompactionCounter, (Tags)metricTags);
            this.compactionTimer = KVSpaceMeters.getTimer((String)RocksDBKVSpace.this.id, (IKVSpaceMetric)RocksDBKVSpaceMetric.ManualCompactionTimer, (Tags)metricTags);
        }

        void close() {
            this.compactionSchedCounter.close();
            this.compactionTimer.close();
        }
    }
}

