/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.dist.client;

import io.reactivex.rxjava3.core.Observable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.bifromq.base.util.CompletableFutureUtil;
import org.apache.bifromq.baserpc.client.IConnectable;
import org.apache.bifromq.baserpc.client.IRPCClient;
import org.apache.bifromq.basescheduler.exception.BackPressureException;
import org.apache.bifromq.dist.client.IDistClient;
import org.apache.bifromq.dist.client.MatchResult;
import org.apache.bifromq.dist.client.PubResult;
import org.apache.bifromq.dist.client.UnmatchResult;
import org.apache.bifromq.dist.client.scheduler.BatchPubCallBuilderFactory;
import org.apache.bifromq.dist.client.scheduler.IPubCallScheduler;
import org.apache.bifromq.dist.client.scheduler.PubCallScheduler;
import org.apache.bifromq.dist.client.scheduler.PubRequest;
import org.apache.bifromq.dist.rpc.proto.DistServiceGrpc;
import org.apache.bifromq.dist.rpc.proto.MatchReply;
import org.apache.bifromq.dist.rpc.proto.MatchRequest;
import org.apache.bifromq.dist.rpc.proto.UnmatchReply;
import org.apache.bifromq.dist.rpc.proto.UnmatchRequest;
import org.apache.bifromq.type.ClientInfo;
import org.apache.bifromq.type.Message;
import org.apache.bifromq.type.RouteMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DistClient
implements IDistClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DistClient.class);
    private final IPubCallScheduler reqScheduler;
    private final IRPCClient rpcClient;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    DistClient(IRPCClient rpcClient) {
        this.rpcClient = rpcClient;
        this.reqScheduler = new PubCallScheduler(new BatchPubCallBuilderFactory(rpcClient));
    }

    public Observable<IConnectable.ConnState> connState() {
        return this.rpcClient.connState();
    }

    @Override
    public CompletableFuture<PubResult> pub(long reqId, String topic, Message message, ClientInfo publisher) {
        return this.reqScheduler.schedule(new PubRequest(publisher, topic, message)).exceptionally(CompletableFutureUtil.unwrap(e -> {
            if (e instanceof BackPressureException) {
                return PubResult.BACK_PRESSURE_REJECTED;
            }
            log.debug("Failed to pub", e);
            return PubResult.ERROR;
        }));
    }

    @Override
    public CompletableFuture<MatchResult> addRoute(long reqId, String tenantId, RouteMatcher matcher, String receiverId, String delivererKey, int subBrokerId, long incarnation) {
        MatchRequest request = MatchRequest.newBuilder().setReqId(reqId).setTenantId(tenantId).setMatcher(matcher).setReceiverId(receiverId).setDelivererKey(delivererKey).setBrokerId(subBrokerId).setIncarnation(incarnation).build();
        log.trace("Handling match request:\n{}", (Object)request);
        return ((CompletableFuture)this.rpcClient.invoke(tenantId, null, (Object)request, DistServiceGrpc.getMatchMethod()).thenApply(v -> switch (v.getResult()) {
            case MatchReply.Result.OK -> MatchResult.OK;
            case MatchReply.Result.EXCEED_LIMIT -> MatchResult.EXCEED_LIMIT;
            case MatchReply.Result.BACK_PRESSURE_REJECTED -> MatchResult.BACK_PRESSURE_REJECTED;
            case MatchReply.Result.TRY_LATER -> MatchResult.TRY_LATER;
            default -> MatchResult.ERROR;
        })).exceptionally(e -> {
            log.debug("Failed to match", e);
            return MatchResult.ERROR;
        });
    }

    @Override
    public CompletableFuture<UnmatchResult> removeRoute(long reqId, String tenantId, RouteMatcher matcher, String receiverId, String delivererKey, int subBrokerId, long incarnation) {
        UnmatchRequest request = UnmatchRequest.newBuilder().setReqId(reqId).setTenantId(tenantId).setMatcher(matcher).setReceiverId(receiverId).setDelivererKey(delivererKey).setBrokerId(subBrokerId).setIncarnation(incarnation).build();
        log.trace("Handling unsub request:\n{}", (Object)request);
        return ((CompletableFuture)this.rpcClient.invoke(tenantId, null, (Object)request, DistServiceGrpc.getUnmatchMethod()).thenApply(v -> switch (v.getResult()) {
            case UnmatchReply.Result.OK -> UnmatchResult.OK;
            case UnmatchReply.Result.NOT_EXISTED -> UnmatchResult.NOT_EXISTED;
            case UnmatchReply.Result.BACK_PRESSURE_REJECTED -> UnmatchResult.BACK_PRESSURE_REJECTED;
            case UnmatchReply.Result.TRY_LATER -> UnmatchResult.TRY_LATER;
            default -> UnmatchResult.ERROR;
        })).exceptionally(e -> {
            log.debug("Failed to unmatch", e);
            return UnmatchResult.ERROR;
        });
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            log.debug("Stopping dist client");
            log.debug("Closing request scheduler");
            this.reqScheduler.close();
            log.debug("Stopping rpc client");
            this.rpcClient.stop();
            log.debug("Dist client stopped");
        }
    }
}

