/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.localengine.memory;

import com.google.protobuf.ByteString;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.bifromq.basekv.localengine.IKVSpaceIterator;
import org.apache.bifromq.basekv.localengine.memory.AbstractInMemKVSpaceReader;
import org.apache.bifromq.basekv.localengine.memory.InMemKVHelper;
import org.apache.bifromq.basekv.localengine.memory.InMemKVSpaceEpoch;
import org.apache.bifromq.basekv.localengine.memory.InMemKVSpaceIterator;
import org.apache.bifromq.basekv.localengine.metrics.KVSpaceOpMeters;
import org.apache.bifromq.basekv.proto.Boundary;
import org.slf4j.Logger;

class InMemKVSpaceCheckpointReader
extends AbstractInMemKVSpaceReader {
    private final InMemKVSpaceEpoch checkpoint;

    protected InMemKVSpaceCheckpointReader(String id, KVSpaceOpMeters readOpMeters, Logger logger, InMemKVSpaceEpoch checkpoint) {
        super(id, readOpMeters, logger);
        this.checkpoint = checkpoint;
    }

    @Override
    protected Map<ByteString, ByteString> metadataMap() {
        return this.checkpoint.metadataMap();
    }

    @Override
    protected NavigableMap<ByteString, ByteString> rangeData() {
        return this.checkpoint.dataMap();
    }

    protected IKVSpaceIterator doNewIterator(Boundary subBoundary) {
        return new InMemKVSpaceIterator(this.rangeData(), subBoundary);
    }

    protected long doSize(Boundary boundary) {
        return InMemKVHelper.sizeOfRange(this.checkpoint.dataMap(), boundary);
    }

    public void close() {
    }
}

