/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecluster.memberlist.agent;

import io.reactivex.rxjava3.core.Observable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.bifromq.basecluster.agent.proto.AgentEndpoint;
import org.apache.bifromq.basecluster.memberlist.agent.IAgentAddressProvider;
import org.apache.bifromq.basecluster.membership.proto.HostEndpoint;
import org.apache.bifromq.basecluster.membership.proto.HostMember;

public class AgentAddressProvider
implements IAgentAddressProvider {
    private final String agentId;
    private final Observable<Map<HostEndpoint, HostMember>> aliveHosts;

    public AgentAddressProvider(String agentId, Observable<Map<HostEndpoint, HostMember>> aliveHosts) {
        this.agentId = agentId;
        this.aliveHosts = aliveHosts;
    }

    @Override
    public Observable<Set<AgentEndpoint>> agentAddress() {
        return this.aliveHosts.map(aliveHostList -> {
            HashSet<AgentEndpoint> agentHosts = new HashSet<AgentEndpoint>();
            for (HostMember record : aliveHostList.values()) {
                if (!record.containsAgent(this.agentId)) continue;
                agentHosts.add(AgentEndpoint.newBuilder().setEndpoint(record.getEndpoint()).setIncarnation(record.getAgentMap().get(this.agentId)).build());
            }
            return agentHosts;
        }).distinctUntilChanged();
    }
}

