/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.handler;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.haproxy.HAProxyMessage;
import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.Map;
import lombok.Generated;
import org.apache.bifromq.mqtt.handler.ChannelAttrs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyProtocolHandler
extends ChannelInboundHandlerAdapter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProxyProtocolHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        try {
            if (msg instanceof HAProxyMessage) {
                HAProxyMessage proxyMsg = (HAProxyMessage)msg;
                switch (proxyMsg.command()) {
                    case PROXY: {
                        String realIP = proxyMsg.sourceAddress();
                        int realPort = proxyMsg.sourcePort();
                        if (realIP == null || realPort <= 0) break;
                        ChannelAttrs.socketAddress(ctx, new InetSocketAddress(realIP, realPort));
                        break;
                    }
                    case LOCAL: {
                        ChannelPipeline pipeline = ctx.pipeline();
                        Iterator entryItr = pipeline.iterator();
                        boolean startRemove = false;
                        while (entryItr.hasNext()) {
                            Map.Entry entry = (Map.Entry)entryItr.next();
                            if (((ChannelHandler)entry.getValue()).getClass().equals(((Object)((Object)this)).getClass())) {
                                startRemove = true;
                                continue;
                            }
                            if (!startRemove) continue;
                            pipeline.remove((ChannelHandler)entry.getValue());
                        }
                        break;
                    }
                }
                proxyMsg.release();
            } else {
                ctx.fireChannelRead(msg);
            }
        }
        finally {
            ctx.pipeline().remove((ChannelHandler)this);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        log.debug("ctx: {}, cause:", (Object)ctx, (Object)cause);
    }
}

