/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.starter.module;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.bifromq.basecluster.IAgentHost;
import org.apache.bifromq.basekv.client.IBaseKVStoreClient;
import org.apache.bifromq.basekv.metaservice.IBaseKVMetaService;
import org.apache.bifromq.basekv.store.option.KVRangeOptions;
import org.apache.bifromq.basekv.store.option.KVRangeStoreOptions;
import org.apache.bifromq.baserpc.server.RPCServerBuilder;
import org.apache.bifromq.dist.client.IDistClient;
import org.apache.bifromq.inbox.client.IInboxClient;
import org.apache.bifromq.inbox.server.IInboxServer;
import org.apache.bifromq.inbox.store.IInboxStore;
import org.apache.bifromq.plugin.eventcollector.EventCollectorManager;
import org.apache.bifromq.plugin.eventcollector.IEventCollector;
import org.apache.bifromq.plugin.resourcethrottler.IResourceThrottler;
import org.apache.bifromq.plugin.resourcethrottler.ResourceThrottlerManager;
import org.apache.bifromq.plugin.settingprovider.ISettingProvider;
import org.apache.bifromq.plugin.settingprovider.SettingProviderManager;
import org.apache.bifromq.retain.client.IRetainClient;
import org.apache.bifromq.sessiondict.client.ISessionDictClient;
import org.apache.bifromq.starter.config.StandaloneConfig;
import org.apache.bifromq.starter.config.model.inbox.InboxServerConfig;
import org.apache.bifromq.starter.config.model.inbox.InboxStoreConfig;
import org.apache.bifromq.starter.module.ServiceInjector;

public class InboxServiceModule
extends AbstractModule {
    protected void configure() {
        this.bind((TypeLiteral)new TypeLiteral<Optional<IInboxServer>>(){}).toProvider(InboxServerProvider.class).in(Singleton.class);
        this.bind((TypeLiteral)new TypeLiteral<Optional<IInboxStore>>(){}).toProvider(InboxStoreProvider.class).in(Singleton.class);
    }

    private static class InboxServerProvider
    implements Provider<Optional<IInboxServer>> {
        private final StandaloneConfig config;
        private final ServiceInjector injector;

        @Inject
        private InboxServerProvider(StandaloneConfig config, ServiceInjector injector) {
            this.config = config;
            this.injector = injector;
        }

        public Optional<IInboxServer> get() {
            InboxServerConfig serverConfig = this.config.getInboxServiceConfig().getServer();
            if (!serverConfig.isEnable()) {
                return Optional.empty();
            }
            return Optional.of(IInboxServer.builder().rpcServerBuilder(this.injector.getInstance(RPCServerBuilder.class)).inboxClient(this.injector.getInstance(IInboxClient.class)).distClient(this.injector.getInstance(IDistClient.class)).inboxStoreClient((IBaseKVStoreClient)this.injector.getInstance(Key.get(IBaseKVStoreClient.class, (Annotation)Names.named((String)"inboxStoreClient")))).workerThreads(serverConfig.getWorkerThreads()).attributes(serverConfig.getAttributes()).defaultGroupTags(serverConfig.getDefaultGroups()).build());
        }
    }

    private static class InboxStoreProvider
    implements Provider<Optional<IInboxStore>> {
        private final StandaloneConfig config;
        private final ServiceInjector injector;

        @Inject
        private InboxStoreProvider(StandaloneConfig config, ServiceInjector injector) {
            this.config = config;
            this.injector = injector;
        }

        public Optional<IInboxStore> get() {
            InboxStoreConfig storeConfig = this.config.getInboxServiceConfig().getStore();
            if (!storeConfig.isEnable()) {
                return Optional.empty();
            }
            return Optional.of(IInboxStore.builder().rpcServerBuilder(this.injector.getInstance(RPCServerBuilder.class)).agentHost(this.injector.getInstance(IAgentHost.class)).metaService(this.injector.getInstance(IBaseKVMetaService.class)).distClient(this.injector.getInstance(IDistClient.class)).inboxClient(this.injector.getInstance(IInboxClient.class)).retainClient(this.injector.getInstance(IRetainClient.class)).sessionDictClient(this.injector.getInstance(ISessionDictClient.class)).inboxStoreClient((IBaseKVStoreClient)this.injector.getInstance(Key.get(IBaseKVStoreClient.class, (Annotation)Names.named((String)"inboxStoreClient")))).settingProvider((ISettingProvider)this.injector.getInstance(SettingProviderManager.class)).eventCollector((IEventCollector)this.injector.getInstance(EventCollectorManager.class)).resourceThrottler((IResourceThrottler)this.injector.getInstance(ResourceThrottlerManager.class)).tickerThreads(storeConfig.getTickerThreads()).workerThreads(storeConfig.getWorkerThreads()).bgTaskExecutor((ScheduledExecutorService)this.injector.getInstance(Key.get(ScheduledExecutorService.class, (Annotation)Names.named((String)"bgTaskScheduler")))).expireRateLimit(storeConfig.getExpireRateLimit()).minGCInterval(Duration.ofSeconds(storeConfig.getMinGCIntervalSeconds())).maxGCInterval(Duration.ofSeconds(storeConfig.getMaxGCIntervalSeconds())).bootstrapDelay(Duration.ofMillis(storeConfig.getBalanceConfig().getBootstrapDelayInMS())).zombieProbeDelay(Duration.ofMillis(storeConfig.getBalanceConfig().getZombieProbeDelayInMS())).balancerRetryDelay(Duration.ofMillis(storeConfig.getBalanceConfig().getRetryDelayInMS())).balancerFactoryConfig(storeConfig.getBalanceConfig().getBalancers()).storeOptions(new KVRangeStoreOptions().setKvRangeOptions(new KVRangeOptions().setMaxWALFatchBatchSize(storeConfig.getMaxWALFetchSize()).setCompactWALThreshold(storeConfig.getCompactWALThreshold()).setEnableLoadEstimation(true)).setSplitHinterFactoryConfig(storeConfig.getSplitHinterConfig().getHinters()).setDataEngineType(storeConfig.getDataEngineConfig().getType()).setDataEngineConf(storeConfig.getDataEngineConfig().toStruct()).setWalEngineType(storeConfig.getWalEngineConfig().getType()).setWalEngineConf(storeConfig.getWalEngineConfig().toStruct())).attributes(storeConfig.getAttributes()).build());
        }
    }
}

