/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.baserpc.marshaller;

import com.google.protobuf.CodedOutputStream;
import io.grpc.Drainable;
import io.grpc.KnownLength;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.bifromq.basehlc.HLC;

class HLCStampedInputStream
extends InputStream
implements Drainable,
KnownLength {
    public static final int HLC_FIELD_ID = Short.MAX_VALUE;
    public static final byte[] HLC_TAG = new byte[3];
    public static final int HLC_FIELD_LENGTH = HLC_TAG.length + 8;
    private final long hlc;
    private final InputStream protoStream;
    private int cursor = 0;

    HLCStampedInputStream(InputStream protoStream) {
        assert (protoStream instanceof Drainable);
        assert (protoStream instanceof KnownLength);
        this.hlc = HLC.INST.get();
        this.protoStream = protoStream;
    }

    public int drainTo(OutputStream target) throws IOException {
        while (this.cursor < HLC_FIELD_LENGTH) {
            target.write(this.read());
        }
        return HLC_FIELD_LENGTH + ((Drainable)this.protoStream).drainTo(target);
    }

    @Override
    public int available() throws IOException {
        return HLC_FIELD_LENGTH - this.cursor + this.protoStream.available();
    }

    @Override
    public int read() throws IOException {
        if (this.cursor < HLC_TAG.length) {
            return HLC_TAG[this.cursor++] & 0xFF;
        }
        if (this.cursor < HLC_FIELD_LENGTH) {
            int shift = (this.cursor - HLC_TAG.length) * 8;
            ++this.cursor;
            return (int)(this.hlc >>> shift & 0xFFL);
        }
        int read = this.protoStream.read();
        if (read == -1) {
            return -1;
        }
        ++this.cursor;
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int total = 0;
        while (len > 0) {
            int r = this.read();
            if (r == -1) {
                return total == 0 ? -1 : total;
            }
            b[off++] = (byte)r;
            ++total;
            --len;
        }
        return total;
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped = 0L;
        while (n > 0L && this.cursor < HLC_FIELD_LENGTH) {
            ++this.cursor;
            --n;
            ++skipped;
        }
        if (n > 0L) {
            skipped += this.protoStream.skip(n);
        }
        return skipped;
    }

    @Override
    public void close() throws IOException {
        this.protoStream.close();
    }

    public InputStream protoStream() {
        return this.protoStream;
    }

    static {
        CodedOutputStream cos = CodedOutputStream.newInstance((byte[])HLC_TAG);
        try {
            cos.writeTag(Short.MAX_VALUE, 1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

