/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.localengine.memory;

import com.google.protobuf.ByteString;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import org.apache.bifromq.basekv.localengine.AbstractKVSpaceReader;
import org.apache.bifromq.basekv.localengine.metrics.KVSpaceOpMeters;
import org.slf4j.Logger;

abstract class AbstractInMemKVSpaceReader
extends AbstractKVSpaceReader {
    protected AbstractInMemKVSpaceReader(String id, KVSpaceOpMeters readOpMeters, Logger logger) {
        super(id, readOpMeters, logger);
    }

    protected abstract Map<ByteString, ByteString> metadataMap();

    protected abstract NavigableMap<ByteString, ByteString> rangeData();

    protected Optional<ByteString> doMetadata(ByteString metaKey) {
        return Optional.ofNullable(this.metadataMap().get(metaKey));
    }

    protected boolean doExist(ByteString key) {
        return this.rangeData().containsKey(key);
    }

    protected Optional<ByteString> doGet(ByteString key) {
        return Optional.ofNullable((ByteString)this.rangeData().get(key));
    }
}

