/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.apiserver.http.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.bifromq.apiserver.http.IHTTPRequestHandler;
import org.apache.bifromq.apiserver.http.handler.utils.JSONUtils;
import org.apache.bifromq.basekv.metaservice.IBaseKVMetaService;

@Path(value="/stores")
final class ListAllStoreHandler
implements IHTTPRequestHandler {
    private final IBaseKVMetaService metaService;
    private final CompositeDisposable disposable = new CompositeDisposable();
    private volatile Set<String> balancerStateObservers = Set.of();

    ListAllStoreHandler(IBaseKVMetaService metaService) {
        this.metaService = metaService;
    }

    @Override
    public void start() {
        this.disposable.add(this.metaService.clusterIds().subscribe(current -> {
            this.balancerStateObservers = current;
        }));
    }

    @Override
    public void close() {
        this.disposable.dispose();
    }

    @Override
    @GET
    @Operation(summary="List the name of stores in BifroMQ cluster")
    @Parameters(value={@Parameter(name="req_id", in=ParameterIn.HEADER, description="optional caller provided request id", schema=@Schema(implementation=Long.class))})
    @RequestBody(required=false)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success", content={@Content(mediaType="application/json")})})
    public CompletableFuture<FullHttpResponse> handle(@Parameter(hidden=true) long reqId, @Parameter(hidden=true) FullHttpRequest req) {
        Set<String> storeClusterName = this.balancerStateObservers;
        DefaultFullHttpResponse resp = new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])this.toJSON(storeClusterName).getBytes()));
        resp.headers().set("Content-Type", (Object)"application/json");
        return CompletableFuture.completedFuture(resp);
    }

    private String toJSON(Set<String> serviceUniqueNames) {
        ObjectMapper mapper = JSONUtils.MAPPER;
        ArrayNode rootObject = mapper.createArrayNode();
        for (String name : serviceUniqueNames) {
            rootObject.add(name);
        }
        return rootObject.toString();
    }
}

