/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.dist.worker;

import com.google.protobuf.ByteString;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.store.api.IKVIterator;
import org.apache.bifromq.basekv.store.api.IKVRangeRefreshableReader;
import org.apache.bifromq.basekv.utils.BoundaryUtil;
import org.apache.bifromq.dist.worker.ITenantsStats;
import org.apache.bifromq.dist.worker.TenantStats;
import org.apache.bifromq.dist.worker.schema.KVSchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TenantsStats
implements ITenantsStats {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantsStats.class);
    private final Map<String, TenantStats> tenantStatsMap = new ConcurrentHashMap<String, TenantStats>();
    private final Supplier<IKVRangeRefreshableReader> readerSupplier;
    private final String[] tags;
    private final ConcurrentLinkedQueue<Runnable> taskQueue = new ConcurrentLinkedQueue();
    private final AtomicBoolean draining = new AtomicBoolean(false);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final StampedLock closeLock = new StampedLock();

    TenantsStats(Supplier<IKVRangeRefreshableReader> readerSupplier, String ... tags) {
        this.readerSupplier = readerSupplier;
        this.tags = tags;
    }

    @Override
    public void incNormalRoutes(String tenantId) {
        this.incNormalRoutes(tenantId, 1);
    }

    @Override
    public void incNormalRoutes(String tenantId, int count) {
        assert (count > 0);
        this.taskQueue.offer(() -> this.doAddNormalRoutes(tenantId, count));
        this.trigger();
    }

    @Override
    public void decNormalRoutes(String tenantId) {
        this.decNormalRoutes(tenantId, 1);
    }

    @Override
    public void decNormalRoutes(String tenantId, int count) {
        assert (count > 0);
        this.taskQueue.offer(() -> this.doAddNormalRoutes(tenantId, -count));
        this.trigger();
    }

    @Override
    public void incSharedRoutes(String tenantId) {
        this.incSharedRoutes(tenantId, 1);
    }

    @Override
    public void incSharedRoutes(String tenantId, int count) {
        assert (count > 0);
        this.taskQueue.offer(() -> this.doAddSharedRoutes(tenantId, count));
        this.trigger();
    }

    @Override
    public void decSharedRoutes(String tenantId) {
        this.decSharedRoutes(tenantId, 1);
    }

    @Override
    public void decSharedRoutes(String tenantId, int count) {
        assert (count > 0);
        this.taskQueue.offer(() -> this.doAddSharedRoutes(tenantId, -count));
        this.trigger();
    }

    @Override
    public void toggleMetering(boolean isLeader) {
        this.taskQueue.offer(() -> this.tenantStatsMap.values().forEach(s -> s.toggleMetering(isLeader)));
        this.trigger();
    }

    @Override
    public void reset() {
        this.taskQueue.offer(this::doReset);
        this.trigger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        long stamp = this.closeLock.writeLock();
        try {
            if (this.closed.compareAndSet(false, true)) {
                CompletableFuture closeFuture = new CompletableFuture();
                this.taskQueue.offer(() -> {
                    this.tenantStatsMap.values().forEach(TenantStats::destroy);
                    this.tenantStatsMap.clear();
                    closeFuture.complete(null);
                });
                this.trigger();
                closeFuture.join();
            }
        }
        finally {
            this.closeLock.unlock(stamp);
        }
    }

    private Supplier<Number> getSpaceUsageProvider(String tenantId) {
        return () -> {
            long stamp = this.closeLock.readLock();
            if (this.closed.get()) {
                this.closeLock.unlock(stamp);
                return 0;
            }
            try {
                Long l;
                block16: {
                    Boundary tenantSection;
                    IKVRangeRefreshableReader reader;
                    block14: {
                        Integer n;
                        block15: {
                            reader = this.readerSupplier.get();
                            try {
                                ByteString tenantStartKey = KVSchemaUtil.tenantBeginKey((String)tenantId);
                                tenantSection = BoundaryUtil.intersect((Boundary)reader.boundary(), (Boundary)BoundaryUtil.toBoundary((ByteString)tenantStartKey, (ByteString)BoundaryUtil.upperBound((ByteString)tenantStartKey)));
                                if (!BoundaryUtil.isNULLRange((Boundary)tenantSection)) break block14;
                                n = 0;
                                if (reader == null) break block15;
                            }
                            catch (Throwable throwable) {
                                try {
                                    if (reader != null) {
                                        try {
                                            reader.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                catch (Exception e) {
                                    log.error("Unexpected error", (Throwable)e);
                                    Integer n2 = 0;
                                    return n2;
                                }
                            }
                            reader.close();
                        }
                        return n;
                    }
                    l = reader.size(tenantSection);
                    if (reader == null) break block16;
                    reader.close();
                }
                return l;
            }
            finally {
                this.closeLock.unlock(stamp);
            }
        };
    }

    private void doAddNormalRoutes(String tenantId, int delta) {
        if (delta == 0) {
            return;
        }
        this.tenantStatsMap.compute(tenantId, (k, v) -> {
            if (v == null) {
                if (delta < 0) {
                    return null;
                }
                v = new TenantStats(tenantId, this.getSpaceUsageProvider(tenantId), this.tags);
            }
            v.addNormalRoutes(delta);
            if (v.isNoRoutes()) {
                v.destroy();
                return null;
            }
            return v;
        });
    }

    private void doAddSharedRoutes(String tenantId, int delta) {
        if (delta == 0) {
            return;
        }
        this.tenantStatsMap.compute(tenantId, (k, v) -> {
            if (v == null) {
                if (delta < 0) {
                    return null;
                }
                v = new TenantStats(tenantId, this.getSpaceUsageProvider(tenantId), this.tags);
            }
            v.addSharedRoutes(delta);
            if (v.isNoRoutes()) {
                v.destroy();
                return null;
            }
            return v;
        });
    }

    private void trigger() {
        if (this.draining.compareAndSet(false, true)) {
            ForkJoinPool.commonPool().execute(this::drain);
        }
    }

    private void drain() {
        try {
            Runnable r;
            while ((r = this.taskQueue.poll()) != null) {
                try {
                    r.run();
                }
                catch (Throwable e) {
                    log.warn("DistWorker tenant stats task failed", e);
                }
            }
        }
        finally {
            this.draining.set(false);
            if (!this.taskQueue.isEmpty()) {
                this.trigger();
            }
        }
    }

    private void doReset() {
        try (IKVRangeRefreshableReader reader = this.readerSupplier.get();
             IKVIterator itr = reader.iterator();){
            this.tenantStatsMap.values().forEach(TenantStats::destroy);
            this.tenantStatsMap.clear();
            itr.seekToFirst();
            while (itr.isValid()) {
                String tenantId = KVSchemaUtil.parseTenantId((ByteString)itr.key());
                byte flag = KVSchemaUtil.parseFlag((ByteString)itr.key());
                if (flag == 1) {
                    this.doAddNormalRoutes(tenantId, 1);
                } else {
                    this.doAddSharedRoutes(tenantId, 1);
                }
                itr.next();
            }
        }
        catch (Throwable e) {
            log.error("Async load dist worker tenant stats failed", e);
        }
    }
}

