/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.fluss.server.kv.autoinc;

/** SequenceGenerator is used to generate auto increment column ID. */
public interface SequenceGenerator {

    /**
     * Retrieves the next sequential value for the auto-increment column.
     *
     * <p>This method provides the next available value for auto-increment columns.
     *
     * @return the next sequential value of the auto-increment column
     */
    long nextVal();

    /**
     * Returns the current upper bound of the sequence range that has been allocated. This is useful
     * for monitoring the current state of the sequence generator.
     */
    AutoIncIDRange currentSequenceRange();

    /**
     * Updates the sequence range with a new range. This method is typically called when the kv
     * tablet is restored from snapshot.
     *
     * @param newRange the new sequence range to be set
     */
    void updateSequenceRange(AutoIncIDRange newRange);
}
