/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.util.record;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.fory.collection.Tuple2;
import org.apache.fory.util.record.RecordComponent;
import org.apache.fory.util.record.RecordInfo;
import org.apache.fory.util.unsafe._JDKAccess;

public class RecordUtils {
    private static final Method IS_RECORD;
    private static final Method GET_RECORD_COMPONENTS;
    private static final Method GET_DECLARING_RECORD;
    private static final Method GET_NAME;
    private static final Method GET_TYPE;
    private static final Method GET_GENERIC_TYPE;
    private static final Method GET_ACCESSOR;
    private static final ClassValue<Boolean> isRecordCache;
    private static final ClassValue<RecordComponent[]> recordComponentsCache;
    private static final ClassValue<Tuple2<Constructor, MethodHandle>> ctrCache;

    public static boolean isRecord(Class<?> cls) {
        if (IS_RECORD == null) {
            return false;
        }
        return isRecordCache.get(cls);
    }

    public static RecordComponent[] getRecordComponents(Class<?> cls) {
        if (GET_RECORD_COMPONENTS == null) {
            return null;
        }
        return recordComponentsCache.get(cls);
    }

    public static Tuple2<Constructor, MethodHandle> getRecordConstructor(Class<?> cls) {
        return ctrCache.get(cls);
    }

    public static MethodHandle getRecordCtrHandle(Class<?> cls) {
        return (MethodHandle)RecordUtils.getRecordConstructor(cls).f1;
    }

    public static Object invokeRecordCtrHandle(MethodHandle handle, Object[] fields) {
        try {
            return handle.invokeWithArguments(fields);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static Object[] buildRecordComponentDefaultValues(Class<?> cls) {
        RecordComponent[] components = RecordUtils.getRecordComponents(cls);
        assert (components != null);
        Object[] defaultValues = new Object[components.length];
        for (int i = 0; i < components.length; ++i) {
            Class<?> type = components[i].getType();
            Comparable<Boolean> defaultValue = null;
            if (type == Boolean.TYPE) {
                defaultValue = false;
            } else if (type == Byte.TYPE) {
                defaultValue = (byte)0;
            } else if (type == Short.TYPE) {
                defaultValue = (short)0;
            } else if (type == Character.TYPE) {
                defaultValue = Character.valueOf('\u0000');
            } else if (type == Integer.TYPE) {
                defaultValue = 0;
            } else if (type == Long.TYPE) {
                defaultValue = 0L;
            } else if (type == Double.TYPE) {
                defaultValue = 0.0;
            } else if (type == Float.TYPE) {
                defaultValue = Float.valueOf(0.0f);
            }
            defaultValues[i] = defaultValue;
        }
        return defaultValues;
    }

    public static int[] buildRecordComponentMapping(Class<?> cls, List<String> fields) {
        HashMap<String, Integer> fieldOrderIndex = new HashMap<String, Integer>(fields.size());
        int counter = 0;
        for (String fieldName : fields) {
            fieldOrderIndex.put(fieldName, counter++);
        }
        RecordComponent[] components = RecordUtils.getRecordComponents(cls);
        if (components == null) {
            return null;
        }
        int[] mapping = new int[components.length];
        for (int i = 0; i < mapping.length; ++i) {
            RecordComponent component = components[i];
            Integer index = (Integer)fieldOrderIndex.get(component.getName());
            mapping[i] = index == null ? -1 : index;
        }
        return mapping;
    }

    public static Map<String, Integer> buildFieldToComponentMapping(Class<?> cls) {
        RecordComponent[] components = RecordUtils.getRecordComponents(cls);
        assert (components != null);
        HashMap<String, Integer> recordComponentsIndex = new HashMap<String, Integer>(components.length);
        int counter = 0;
        for (RecordComponent component : components) {
            recordComponentsIndex.put(component.getName(), counter++);
        }
        return recordComponentsIndex;
    }

    public static Object[] remapping(RecordInfo recordInfo, Object[] fields) {
        int[] recordComponentsIndex = recordInfo.getRecordComponentsIndex();
        Object[] recordComponents = recordInfo.getRecordComponents();
        Object[] recordComponentsDefaultValues = recordInfo.getRecordComponentsDefaultValues();
        for (int i = 0; i < recordComponentsIndex.length; ++i) {
            int index = recordComponentsIndex[i];
            recordComponents[i] = index != -1 ? fields[index] : recordComponentsDefaultValues[i];
        }
        return recordComponents;
    }

    static {
        Method getAccessor;
        Method getGenericType;
        Method getDeclaringRecord;
        Method getType;
        Method getName;
        Method getRecordComponents;
        Method isRecord;
        try {
            isRecord = Class.class.getDeclaredMethod("isRecord", new Class[0]);
            getRecordComponents = Class.class.getMethod("getRecordComponents", new Class[0]);
            Class<?> componentClass = Class.forName("java.lang.reflect.RecordComponent");
            getName = componentClass.getMethod("getName", new Class[0]);
            getType = componentClass.getMethod("getType", new Class[0]);
            getDeclaringRecord = componentClass.getMethod("getDeclaringRecord", new Class[0]);
            getGenericType = componentClass.getMethod("getGenericType", new Class[0]);
            getAccessor = componentClass.getMethod("getAccessor", new Class[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            isRecord = null;
            getRecordComponents = null;
            getDeclaringRecord = null;
            getName = null;
            getType = null;
            getGenericType = null;
            getAccessor = null;
        }
        IS_RECORD = isRecord;
        GET_RECORD_COMPONENTS = getRecordComponents;
        GET_DECLARING_RECORD = getDeclaringRecord;
        GET_NAME = getName;
        GET_TYPE = getType;
        GET_GENERIC_TYPE = getGenericType;
        GET_ACCESSOR = getAccessor;
        isRecordCache = new ClassValue<Boolean>(){

            @Override
            protected Boolean computeValue(Class<?> type) {
                try {
                    return (boolean)((Boolean)IS_RECORD.invoke(type, new Object[0]));
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        recordComponentsCache = new ClassValue<RecordComponent[]>(){

            @Override
            protected RecordComponent[] computeValue(Class<?> type) {
                try {
                    MethodHandles.Lookup lookup = _JDKAccess._trustedLookup(type);
                    Object[] components = (Object[])GET_RECORD_COMPONENTS.invoke(type, new Object[0]);
                    RecordComponent[] recordComponents = new RecordComponent[components.length];
                    for (int i = 0; i < components.length; ++i) {
                        Object component = components[i];
                        Method accessor = (Method)GET_ACCESSOR.invoke(component, new Object[0]);
                        Class fieldType = (Class)GET_TYPE.invoke(component, new Object[0]);
                        MethodHandle handle = lookup.unreflect(accessor);
                        Object getter = _JDKAccess.makeGetterFunction(lookup, handle, fieldType);
                        recordComponents[i] = new RecordComponent((Class)GET_DECLARING_RECORD.invoke(component, new Object[0]), (String)GET_NAME.invoke(component, new Object[0]), fieldType, (Type)GET_GENERIC_TYPE.invoke(component, new Object[0]), accessor, getter);
                    }
                    return recordComponents;
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        ctrCache = new ClassValue<Tuple2<Constructor, MethodHandle>>(){

            @Override
            protected Tuple2<Constructor, MethodHandle> computeValue(Class<?> type) {
                Constructor<?> constructor;
                RecordComponent[] components = RecordUtils.getRecordComponents(type);
                if (components == null) {
                    return null;
                }
                Class[] paramTypes = (Class[])Arrays.stream(components).map(RecordComponent::getType).toArray(Class[]::new);
                try {
                    constructor = type.getDeclaredConstructor(paramTypes);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
                MethodHandles.Lookup lookup = _JDKAccess._trustedLookup(type);
                if (lookup != null) {
                    try {
                        MethodHandle handle = lookup.findConstructor(type, MethodType.methodType(Void.TYPE, paramTypes));
                        return Tuple2.of(constructor, handle);
                    }
                    catch (IllegalAccessException | NoSuchMethodException e) {
                        return Tuple2.of(constructor, null);
                    }
                }
                return Tuple2.of(constructor, null);
            }
        };
    }
}

