/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.composite;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.util.Map;

public class JsonWritingUtils {
    public static void writeMapEntries(JsonGenerator generator, Map<?, ?> map) throws IOException, JsonMappingException {
        if (map != null) {
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                generator.writeFieldName(entry.getKey().toString());
                generator.writeObject(entry.getValue());
            }
        }
    }

    public static void writeMapStringFields(JsonGenerator generator, String fieldName, Map<String, String> map) throws IOException, JsonMappingException {
        JsonWritingUtils.writeMapStringFields(generator, fieldName, map, false);
    }

    public static void writeMapStringFields(JsonGenerator generator, String fieldName, Map<String, String> map, boolean lowerCaseKeys) throws IOException, JsonMappingException {
        if (JsonWritingUtils.shouldWriteField(fieldName) && map != null && !map.isEmpty()) {
            generator.writeObjectFieldStart(fieldName);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String key = entry.getKey() != null && lowerCaseKeys ? entry.getKey().toLowerCase() : entry.getKey();
                JsonWritingUtils.writeStringField(generator, key, entry.getValue());
            }
            generator.writeEndObject();
        }
    }

    public static void writeStringArrayField(JsonGenerator generator, String fieldName, String[] fieldValues) throws IOException {
        if (JsonWritingUtils.shouldWriteField(fieldName) && fieldValues != null && fieldValues.length > 0) {
            generator.writeArrayFieldStart(fieldName);
            for (String fieldValue : fieldValues) {
                generator.writeString(fieldValue);
            }
            generator.writeEndArray();
        }
    }

    public static void writeStringField(JsonGenerator generator, String fieldName, String fieldValue) throws IOException {
        if (JsonWritingUtils.shouldWriteField(fieldName) && fieldValue != null) {
            generator.writeStringField(fieldName, fieldValue);
        }
    }

    public static void writeNumberField(JsonGenerator generator, String fieldName, int fieldValue) throws IOException {
        if (JsonWritingUtils.shouldWriteField(fieldName)) {
            generator.writeNumberField(fieldName, fieldValue);
        }
    }

    public static void writeNumberField(JsonGenerator generator, String fieldName, long fieldValue) throws IOException {
        if (JsonWritingUtils.shouldWriteField(fieldName)) {
            generator.writeNumberField(fieldName, fieldValue);
        }
    }

    public static boolean shouldWriteField(String fieldName) {
        return fieldName != null && !fieldName.equals("[ignore]");
    }
}

