/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model;

import com.github.victools.jsonschema.generator.MemberScope;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigPart;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KProperty;
import kotlin.reflect.KType;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.springframework.core.KotlinDetector;

public class KotlinModule
implements Module {
    public void applyToConfigBuilder(SchemaGeneratorConfigBuilder builder) {
        SchemaGeneratorConfigPart fieldConfigPart = builder.forFields();
        this.applyToConfigBuilderPart(fieldConfigPart);
    }

    private void applyToConfigBuilderPart(SchemaGeneratorConfigPart<?> configPart) {
        configPart.withNullableCheck(this::isNullable);
        configPart.withPropertyNameOverrideResolver(this::getPropertyName);
        configPart.withRequiredCheck(this::isRequired);
        configPart.withIgnoreCheck(this::shouldIgnore);
    }

    private Boolean isNullable(MemberScope<?, ?> member) {
        KProperty<?> kotlinProperty = this.getKotlinProperty(member);
        if (kotlinProperty != null) {
            return kotlinProperty.getReturnType().isMarkedNullable();
        }
        return null;
    }

    private String getPropertyName(MemberScope<?, ?> member) {
        KProperty<?> kotlinProperty = this.getKotlinProperty(member);
        if (kotlinProperty != null) {
            return kotlinProperty.getName();
        }
        return null;
    }

    private boolean isRequired(MemberScope<?, ?> member) {
        KProperty<?> kotlinProperty = this.getKotlinProperty(member);
        if (kotlinProperty != null) {
            KType returnType = kotlinProperty.getReturnType();
            boolean isNonNullable = !returnType.isMarkedNullable();
            Class declaringClass = member.getDeclaringType().getErasedType();
            KClass kotlinClass = JvmClassMappingKt.getKotlinClass((Class)declaringClass);
            Set<String> constructorParamsWithoutDefault = this.getConstructorParametersWithoutDefault(kotlinClass);
            boolean isInConstructor = constructorParamsWithoutDefault.contains(kotlinProperty.getName());
            return isNonNullable && isInConstructor;
        }
        return false;
    }

    private boolean shouldIgnore(MemberScope<?, ?> member) {
        return member.getRawMember().isSynthetic();
    }

    private KProperty<?> getKotlinProperty(MemberScope<?, ?> member) {
        Class declaringClass = member.getDeclaringType().getErasedType();
        if (KotlinDetector.isKotlinType((Class)declaringClass)) {
            KClass kotlinClass = JvmClassMappingKt.getKotlinClass((Class)declaringClass);
            for (KProperty prop : KClasses.getMemberProperties((KClass)kotlinClass)) {
                Field javaField = ReflectJvmMapping.getJavaField((KProperty)prop);
                if (javaField == null || !javaField.equals(member.getRawMember())) continue;
                return prop;
            }
        }
        return null;
    }

    private Set<String> getConstructorParametersWithoutDefault(KClass<?> kotlinClass) {
        HashSet<String> paramsWithoutDefault = new HashSet<String>();
        KFunction primaryConstructor = KClasses.getPrimaryConstructor(kotlinClass);
        if (primaryConstructor != null) {
            primaryConstructor.getParameters().forEach(param -> {
                String name;
                if (param.getKind() != KParameter.Kind.INSTANCE && !param.isOptional() && (name = param.getName()) != null) {
                    paramsWithoutDefault.add(name);
                }
            });
        }
        return paramsWithoutDefault;
    }
}

