/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.console.controller;

import jakarta.servlet.http.HttpServletResponse;
import org.apache.seata.common.result.Code;
import org.apache.seata.common.result.SingleResult;
import org.apache.seata.console.security.User;
import org.apache.seata.console.utils.JwtTokenUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/auth"})
public class AuthController {
    @Autowired
    private JwtTokenUtils jwtTokenUtils;
    @Autowired
    private AuthenticationManager authenticationManager;

    @PostMapping(value={"/login"})
    public SingleResult<String> login(HttpServletResponse response, @RequestBody User user) {
        UsernamePasswordAuthenticationToken authenticationToken = new UsernamePasswordAuthenticationToken((Object)user.getUsername(), (Object)user.getPassword());
        try {
            Authentication authentication = this.authenticationManager.authenticate((Authentication)authenticationToken);
            SecurityContextHolder.getContext().setAuthentication(authentication);
            String token = this.jwtTokenUtils.createToken(authentication);
            String authHeader = "Bearer " + token;
            response.addHeader("Authorization", authHeader);
            return SingleResult.success((Object)authHeader);
        }
        catch (BadCredentialsException authentication) {
            return SingleResult.failure((Code)Code.LOGIN_FAILED);
        }
    }
}

