/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.mcp.exception;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.springframework.http.HttpStatusCode;

public class ServiceCallException
extends RuntimeException {
    private final HttpStatusCode httpStatus;
    private final Instant timestamp;

    public ServiceCallException(String message, Throwable cause) {
        super(message, cause);
        this.httpStatus = null;
        this.timestamp = Instant.now();
    }

    public ServiceCallException(String message) {
        super(message);
        this.httpStatus = null;
        this.timestamp = Instant.now();
    }

    public ServiceCallException(String message, HttpStatusCode httpStatus) {
        super(message);
        this.httpStatus = httpStatus;
        this.timestamp = Instant.now();
    }

    public Map<String, Object> toErrorResponse() {
        HashMap<String, Object> error = new HashMap<String, Object>();
        error.put("message", this.getMessage());
        error.put("timestamp", this.timestamp.toString());
        error.put("httpStatus", this.httpStatus != null ? Integer.valueOf(this.httpStatus.value()) : null);
        return error;
    }
}

