/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DecodeableControl;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.ldap.sdk.unboundidds.controls.RecentLoginHistory;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONException;
import com.unboundid.util.json.JSONObject;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class GetRecentLoginHistoryResponseControl
extends Control
implements DecodeableControl {
    @NotNull
    public static final String GET_RECENT_LOGIN_HISTORY_RESPONSE_OID = "1.3.6.1.4.1.30221.2.5.62";
    private static final long serialVersionUID = -4604204310334007290L;
    @NotNull
    private final RecentLoginHistory recentLoginHistory;

    GetRecentLoginHistoryResponseControl() {
        this.recentLoginHistory = null;
    }

    public GetRecentLoginHistoryResponseControl(@NotNull RecentLoginHistory recentLoginHistory) {
        super(GET_RECENT_LOGIN_HISTORY_RESPONSE_OID, false, new ASN1OctetString(recentLoginHistory.asJSONObject().toString()));
        this.recentLoginHistory = recentLoginHistory;
    }

    public GetRecentLoginHistoryResponseControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        super(oid, isCritical, value);
        JSONObject jsonObject;
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_RECENT_LOGIN_HISTORY_RESPONSE_NO_VALUE.get());
        }
        try {
            jsonObject = new JSONObject(value.stringValue());
        }
        catch (JSONException e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_RECENT_LOGIN_HISTORY_RESPONSE_VALUE_NOT_JSON.get(e.getMessage()), e);
        }
        try {
            this.recentLoginHistory = new RecentLoginHistory(jsonObject);
        }
        catch (LDAPException e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_RECENT_LOGIN_HISTORY_RESPONSE_CANNOT_PARSE_VALUE.get(e.getMessage()), e);
        }
    }

    @Override
    @NotNull
    public GetRecentLoginHistoryResponseControl decodeControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        return new GetRecentLoginHistoryResponseControl(oid, isCritical, value);
    }

    @NotNull
    public RecentLoginHistory getRecentLoginHistory() {
        return this.recentLoginHistory;
    }

    @Nullable
    public static GetRecentLoginHistoryResponseControl get(@NotNull BindResult bindResult) throws LDAPException {
        Control c = bindResult.getResponseControl(GET_RECENT_LOGIN_HISTORY_RESPONSE_OID);
        if (c == null) {
            return null;
        }
        if (c instanceof GetRecentLoginHistoryResponseControl) {
            return (GetRecentLoginHistoryResponseControl)c;
        }
        return new GetRecentLoginHistoryResponseControl(c.getOID(), c.isCritical(), c.getValue());
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_GET_RECENT_LOGIN_HISTORY_RESPONSE.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("GetRecentLoginHistoryResponseControl(recentLoginHistory=");
        buffer.append(this.recentLoginHistory.toString());
        buffer.append(')');
    }
}

