/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DecodeableControl;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Deprecated
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class InteractiveTransactionSpecificationResponseControl
extends Control
implements DecodeableControl {
    @NotNull
    public static final String INTERACTIVE_TRANSACTION_SPECIFICATION_RESPONSE_OID = "1.3.6.1.4.1.30221.2.5.4";
    private static final byte TYPE_TXN_VALID = -128;
    private static final byte TYPE_BASE_DNS = -95;
    private static final long serialVersionUID = -4323085263241417543L;
    private final boolean transactionValid;
    @Nullable
    private final List<String> baseDNs;

    InteractiveTransactionSpecificationResponseControl() {
        this.transactionValid = false;
        this.baseDNs = null;
    }

    public InteractiveTransactionSpecificationResponseControl(boolean transactionValid, @Nullable List<String> baseDNs) {
        super(INTERACTIVE_TRANSACTION_SPECIFICATION_RESPONSE_OID, false, InteractiveTransactionSpecificationResponseControl.encodeValue(transactionValid, baseDNs));
        this.transactionValid = transactionValid;
        this.baseDNs = baseDNs == null ? null : Collections.unmodifiableList(new ArrayList<String>(baseDNs));
    }

    public InteractiveTransactionSpecificationResponseControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        super(oid, isCritical, value);
        ASN1Element[] elements;
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_INT_TXN_RESPONSE_NO_VALUE.get());
        }
        try {
            ASN1Element valueElement = ASN1Element.decode(value.getValue());
            elements = ASN1Sequence.decodeAsSequence(valueElement).elements();
        }
        catch (Exception e) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_INT_TXN_RESPONSE_VALUE_NOT_SEQUENCE.get(e.getMessage()), e);
        }
        Boolean isValid = null;
        ArrayList<String> baseDNList = null;
        block10: for (ASN1Element element : elements) {
            switch (element.getType()) {
                case -128: {
                    try {
                        isValid = ASN1Boolean.decodeAsBoolean(element).booleanValue();
                        continue block10;
                    }
                    catch (Exception e) {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_INT_TXN_RESPONSE_TXN_VALID_NOT_BOOLEAN.get(e.getMessage()), e);
                    }
                }
                case -95: {
                    try {
                        ASN1Sequence s = ASN1Sequence.decodeAsSequence(element);
                        baseDNList = new ArrayList<String>(s.elements().length);
                        for (ASN1Element e : s.elements()) {
                            baseDNList.add(ASN1OctetString.decodeAsOctetString(e).stringValue());
                        }
                        continue block10;
                    }
                    catch (Exception e) {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_INT_TXN_RESPONSE_BASE_DNS_NOT_SEQUENCE.get(e.getMessage()), e);
                    }
                }
                default: {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_INT_TXN_RESPONSE_INVALID_ELEMENT_TYPE.get(StaticUtils.toHex(element.getType())));
                }
            }
        }
        if (isValid == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_INT_TXN_RESPONSE_NO_TXN_VALID.get());
        }
        this.transactionValid = isValid;
        this.baseDNs = baseDNList == null ? null : Collections.unmodifiableList(baseDNList);
    }

    @NotNull
    private static ASN1OctetString encodeValue(boolean transactionValid, @Nullable List<String> baseDNs) {
        ASN1Element[] elements;
        if (baseDNs == null) {
            elements = new ASN1Element[]{new ASN1Boolean(-128, transactionValid)};
        } else {
            ASN1Element[] baseDNElements = new ASN1Element[baseDNs.size()];
            for (int i = 0; i < baseDNElements.length; ++i) {
                baseDNElements[i] = new ASN1OctetString(baseDNs.get(i));
            }
            elements = new ASN1Element[]{new ASN1Boolean(-128, transactionValid), new ASN1Sequence(-95, baseDNElements)};
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    @Override
    @NotNull
    public InteractiveTransactionSpecificationResponseControl decodeControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        return new InteractiveTransactionSpecificationResponseControl(oid, isCritical, value);
    }

    @Nullable
    public static InteractiveTransactionSpecificationResponseControl get(@NotNull LDAPResult result) throws LDAPException {
        Control c = result.getResponseControl(INTERACTIVE_TRANSACTION_SPECIFICATION_RESPONSE_OID);
        if (c == null) {
            return null;
        }
        if (c instanceof InteractiveTransactionSpecificationResponseControl) {
            return (InteractiveTransactionSpecificationResponseControl)c;
        }
        return new InteractiveTransactionSpecificationResponseControl(c.getOID(), c.isCritical(), c.getValue());
    }

    public boolean transactionValid() {
        return this.transactionValid;
    }

    @Nullable
    public List<String> getBaseDNs() {
        return this.baseDNs;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_INTERACTIVE_TXN_RESPONSE.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("InteractiveTransactionSpecificationResponseControl(");
        buffer.append("transactionValid=");
        buffer.append(this.transactionValid);
        buffer.append(", baseDNs=");
        if (this.baseDNs == null) {
            buffer.append("null");
        } else {
            buffer.append('{');
            for (int i = 0; i < this.baseDNs.size(); ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append('\'');
                buffer.append(this.baseDNs.get(i));
                buffer.append('\'');
            }
            buffer.append('}');
        }
        buffer.append(", isCritical=");
        buffer.append(this.isCritical());
        buffer.append(')');
    }
}

