/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import com.google.inject.util.Modules;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.apache.james.ExtraProperties;
import org.apache.james.GuiceJamesServer;
import org.apache.james.JamesServerMain;
import org.apache.james.PostgresJamesConfiguration;
import org.apache.james.PostgresJmapModule;
import org.apache.james.SearchConfiguration;
import org.apache.james.SearchModuleChooser;
import org.apache.james.data.UsersRepositoryModuleChooser;
import org.apache.james.jmap.JMAPListenerModule;
import org.apache.james.jmap.JMAPModule;
import org.apache.james.json.DTO;
import org.apache.james.json.DTOModule;
import org.apache.james.modules.BlobExportMechanismModule;
import org.apache.james.modules.DistributedTaskSerializationModule;
import org.apache.james.modules.MailboxModule;
import org.apache.james.modules.MailetProcessingModule;
import org.apache.james.modules.RunArgumentsModule;
import org.apache.james.modules.TasksCleanupTaskSerializationModule;
import org.apache.james.modules.blobstore.BlobStoreCacheModulesChooser;
import org.apache.james.modules.blobstore.BlobStoreConfiguration;
import org.apache.james.modules.blobstore.BlobStoreModulesChooser;
import org.apache.james.modules.data.PostgresDLPConfigurationStoreModule;
import org.apache.james.modules.data.PostgresDataJmapModule;
import org.apache.james.modules.data.PostgresDataModule;
import org.apache.james.modules.data.PostgresDelegationStoreModule;
import org.apache.james.modules.data.PostgresDropListsModule;
import org.apache.james.modules.data.PostgresEventStoreModule;
import org.apache.james.modules.data.PostgresUsersRepositoryModule;
import org.apache.james.modules.data.PostgresVacationModule;
import org.apache.james.modules.data.SievePostgresRepositoryModules;
import org.apache.james.modules.event.JMAPEventBusModule;
import org.apache.james.modules.event.MailboxEventBusModule;
import org.apache.james.modules.events.PostgresDeadLetterModule;
import org.apache.james.modules.mailbox.DefaultEventModule;
import org.apache.james.modules.mailbox.PostgresDeletedMessageVaultModule;
import org.apache.james.modules.mailbox.PostgresMailboxModule;
import org.apache.james.modules.mailbox.RLSSupportPostgresMailboxModule;
import org.apache.james.modules.mailbox.TikaMailboxModule;
import org.apache.james.modules.plugins.QuotaMailingModule;
import org.apache.james.modules.protocols.IMAPServerModule;
import org.apache.james.modules.protocols.JMAPServerModule;
import org.apache.james.modules.protocols.JmapEventBusModule;
import org.apache.james.modules.protocols.LMTPServerModule;
import org.apache.james.modules.protocols.ManageSieveServerModule;
import org.apache.james.modules.protocols.POP3ServerModule;
import org.apache.james.modules.protocols.ProtocolHandlerModule;
import org.apache.james.modules.protocols.SMTPServerModule;
import org.apache.james.modules.queue.activemq.ActiveMQQueueModule;
import org.apache.james.modules.queue.rabbitmq.FakeMailQueueViewModule;
import org.apache.james.modules.queue.rabbitmq.RabbitMQMailQueueModule;
import org.apache.james.modules.queue.rabbitmq.RabbitMQModule;
import org.apache.james.modules.server.DKIMMailetModule;
import org.apache.james.modules.server.DLPRoutesModule;
import org.apache.james.modules.server.DataRoutesModules;
import org.apache.james.modules.server.DropListsRoutesModule;
import org.apache.james.modules.server.InconsistencyQuotasSolvingRoutesModule;
import org.apache.james.modules.server.JMXServerModule;
import org.apache.james.modules.server.JmapTasksModule;
import org.apache.james.modules.server.JmapUploadCleanupModule;
import org.apache.james.modules.server.MailQueueRoutesModule;
import org.apache.james.modules.server.MailRepositoriesRoutesModule;
import org.apache.james.modules.server.MailboxRoutesModule;
import org.apache.james.modules.server.MailboxesExportRoutesModule;
import org.apache.james.modules.server.RabbitMailQueueRoutesModule;
import org.apache.james.modules.server.ReIndexingModule;
import org.apache.james.modules.server.SieveRoutesModule;
import org.apache.james.modules.server.TaskManagerModule;
import org.apache.james.modules.server.UserIdentityModule;
import org.apache.james.modules.server.WebAdminReIndexingTaskSerializationModule;
import org.apache.james.modules.server.WebAdminServerModule;
import org.apache.james.modules.task.DistributedTaskManagerModule;
import org.apache.james.modules.task.PostgresTaskExecutionDetailsProjectionGuiceModule;
import org.apache.james.modules.vault.DeletedMessageVaultRoutesModule;
import org.apache.james.modules.webadmin.TasksCleanupRoutesModule;
import org.apache.james.server.core.configuration.Configuration;
import org.apache.james.vault.VaultConfiguration;

public class PostgresJamesServerMain
implements JamesServerMain {
    private static final Module EVENT_STORE_JSON_SERIALIZATION_DEFAULT_MODULE = binder -> binder.bind(new TypeLiteral<Set<DTOModule<?, ? extends DTO>>>(){}).annotatedWith((Annotation)Names.named((String)"EventNestedTypes")).toInstance((Object)ImmutableSet.of());
    private static final Module WEBADMIN = Modules.combine((Module[])new Module[]{new WebAdminServerModule(), new DataRoutesModules(), new InconsistencyQuotasSolvingRoutesModule(), new MailboxRoutesModule(), new MailQueueRoutesModule(), new MailRepositoriesRoutesModule(), new ReIndexingModule(), new SieveRoutesModule(), new WebAdminReIndexingTaskSerializationModule(), new MailboxesExportRoutesModule(), new UserIdentityModule(), new DLPRoutesModule(), new JmapUploadCleanupModule(), new JmapTasksModule(), new TasksCleanupRoutesModule(), new TasksCleanupTaskSerializationModule()});
    private static final Module PROTOCOLS = Modules.combine((Module[])new Module[]{new IMAPServerModule(), new LMTPServerModule(), new ManageSieveServerModule(), new POP3ServerModule(), new ProtocolHandlerModule(), new SMTPServerModule(), WEBADMIN});
    private static final Module POSTGRES_SERVER_MODULE = Modules.combine((Module[])new Module[]{new BlobExportMechanismModule(), new PostgresDelegationStoreModule(), new PostgresMailboxModule(), new PostgresDeadLetterModule(), new PostgresDataModule(), new MailboxModule(), new SievePostgresRepositoryModules(), new PostgresEventStoreModule(), new TikaMailboxModule(), new PostgresDLPConfigurationStoreModule(), new PostgresVacationModule(), EVENT_STORE_JSON_SERIALIZATION_DEFAULT_MODULE});
    public static final Module JMAP = Modules.combine((Module[])new Module[]{new PostgresJmapModule(), new PostgresDataJmapModule(), new JmapEventBusModule(), new JMAPServerModule(), JMAPModule.INSTANCE});
    public static final Module PLUGINS = new QuotaMailingModule();
    private static final Function<PostgresJamesConfiguration, Module> POSTGRES_MODULE_AGGREGATE = configuration -> Modules.override((Module[])new Module[]{Modules.combine((Module[])new Module[]{new MailetProcessingModule(), new DKIMMailetModule(), POSTGRES_SERVER_MODULE, JMAP, PROTOCOLS, PLUGINS})}).with(PostgresJamesServerMain.chooseEventBusModules(configuration));

    public static void main(String[] args) throws Exception {
        ExtraProperties.initialize();
        PostgresJamesConfiguration configuration = PostgresJamesConfiguration.builder().useWorkingDirectoryEnvProperty().build();
        LOGGER.info("Loading configuration {}", (Object)configuration.toString());
        GuiceJamesServer server = PostgresJamesServerMain.createServer(configuration).combineWith(new Module[]{new JMXServerModule()}).overrideWith(new Module[]{new RunArgumentsModule(args)});
        JamesServerMain.main((GuiceJamesServer)server);
    }

    public static GuiceJamesServer createServer(PostgresJamesConfiguration configuration) {
        SearchConfiguration searchConfiguration = configuration.searchConfiguration();
        return GuiceJamesServer.forConfiguration((Configuration)configuration).combineWith(new Module[]{POSTGRES_MODULE_AGGREGATE.apply(configuration)}).combineWith((Collection)SearchModuleChooser.chooseModules((SearchConfiguration)searchConfiguration)).combineWith(PostgresJamesServerMain.chooseUsersRepositoryModule(configuration)).combineWith(PostgresJamesServerMain.chooseBlobStoreModules(configuration)).combineWith(new Module[]{PostgresJamesServerMain.chooseDeletedMessageVaultModules(configuration.getDeletedMessageVaultConfiguration())}).combineWith(new Module[]{PostgresJamesServerMain.chooseRLSSupportPostgresMailboxModule(configuration)}).overrideWith(new Module[]{PostgresJamesServerMain.chooseJmapModules(configuration)}).overrideWith(PostgresJamesServerMain.chooseTaskManagerModules(configuration)).overrideWith(new Module[]{PostgresJamesServerMain.chooseDropListsModule(configuration)});
    }

    private static List<Module> chooseUsersRepositoryModule(PostgresJamesConfiguration configuration) {
        return List.of(PostgresUsersRepositoryModule.USER_CONFIGURATION_MODULE, Modules.combine((Iterable)new UsersRepositoryModuleChooser((Module)new PostgresUsersRepositoryModule()).chooseModules(configuration.getUsersRepositoryImplementation())));
    }

    private static List<Module> chooseBlobStoreModules(PostgresJamesConfiguration configuration) {
        ImmutableList.Builder builder = ImmutableList.builder().addAll((Iterable)BlobStoreModulesChooser.chooseModules((BlobStoreConfiguration)configuration.blobStoreConfiguration())).add((Object)new BlobStoreCacheModulesChooser.CacheDisabledModule());
        return builder.build();
    }

    public static List<Module> chooseTaskManagerModules(PostgresJamesConfiguration configuration) {
        switch (configuration.eventBusImpl()) {
            case IN_MEMORY: {
                return List.of(new TaskManagerModule(), new PostgresTaskExecutionDetailsProjectionGuiceModule());
            }
            case RABBITMQ: {
                return List.of(new DistributedTaskManagerModule());
            }
        }
        throw new RuntimeException("Unsupported event-bus implementation " + configuration.eventBusImpl().name());
    }

    public static List<Module> chooseEventBusModules(PostgresJamesConfiguration configuration) {
        switch (configuration.eventBusImpl()) {
            case IN_MEMORY: {
                return List.of(new DefaultEventModule(), new ActiveMQQueueModule());
            }
            case RABBITMQ: {
                return List.of(Modules.override((Module[])new Module[]{new DefaultEventModule()}).with(new Module[]{new MailboxEventBusModule()}), new RabbitMQModule(), new RabbitMQMailQueueModule(), new FakeMailQueueViewModule(), new RabbitMailQueueRoutesModule(), new DistributedTaskSerializationModule());
            }
        }
        throw new RuntimeException("Unsupported event-bus implementation " + configuration.eventBusImpl().name());
    }

    private static Module chooseDeletedMessageVaultModules(VaultConfiguration vaultConfiguration) {
        if (vaultConfiguration.isEnabled()) {
            return Modules.combine((Module[])new Module[]{new PostgresDeletedMessageVaultModule(), new DeletedMessageVaultRoutesModule()});
        }
        return Modules.EMPTY_MODULE;
    }

    private static Module chooseJmapModules(PostgresJamesConfiguration configuration) {
        if (configuration.isJmapEnabled()) {
            if (configuration.eventBusImpl() == PostgresJamesConfiguration.EventBusImpl.RABBITMQ) {
                return Modules.combine((Module[])new Module[]{new JMAPEventBusModule(), new JMAPListenerModule()});
            }
            return new JMAPListenerModule();
        }
        return binder -> {};
    }

    private static Module chooseDropListsModule(PostgresJamesConfiguration configuration) {
        if (configuration.isDropListsEnabled()) {
            return Modules.combine((Module[])new Module[]{new PostgresDropListsModule(), new DropListsRoutesModule()});
        }
        return binder -> {};
    }

    private static Module chooseRLSSupportPostgresMailboxModule(PostgresJamesConfiguration configuration) {
        if (configuration.isRlsEnabled()) {
            return new RLSSupportPostgresMailboxModule();
        }
        return Modules.EMPTY_MODULE;
    }
}

