/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.netty;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.james.protocols.api.ProtocolServer;
import org.apache.james.util.concurrent.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractAsyncServer
implements ProtocolServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAsyncServer.class);
    public static final int DEFAULT_IO_WORKER_COUNT = Runtime.getRuntime().availableProcessors() * 2;
    public static final int DEFAULT_BOSS_WORKER_COUNT = 2;
    public static final int SHUTDOWN_QUIET_PERIOD = 500;
    public static final int SHUTDOWN_TIMEOUT = 3000;
    private volatile int backlog = 250;
    private volatile int timeout = 120;
    private Optional<EventLoopGroup> bossGroup;
    private EventLoopGroup workerGroup;
    private volatile boolean started;
    private final ChannelGroup channels = new DefaultChannelGroup((EventExecutor)ImmediateEventExecutor.INSTANCE);
    private volatile int ioWorker = DEFAULT_IO_WORKER_COUNT;
    private volatile Optional<Integer> bossWorker = Optional.of(2);
    private List<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>();
    protected String jmxName;
    private boolean gracefulShutdown = true;
    private boolean useEpoll = false;
    protected WriteBufferWaterMark writeBufferWaterMark = WriteBufferWaterMark.DEFAULT;

    public synchronized void setListenAddresses(InetSocketAddress ... addresses) {
        if (this.started) {
            throw new IllegalStateException("Can only be set when the server is not running");
        }
        this.addresses = ImmutableList.copyOf((Object[])addresses);
    }

    public void setGracefulShutdown(boolean gracefulShutdown) {
        this.gracefulShutdown = gracefulShutdown;
    }

    public void setUseEpoll(boolean useEpoll) {
        this.useEpoll = useEpoll;
    }

    public void setWriteBufferWaterMark(WriteBufferWaterMark writeBufferWaterMark) {
        this.writeBufferWaterMark = writeBufferWaterMark;
    }

    public void setIoWorkerCount(int ioWorker) {
        if (this.started) {
            throw new IllegalStateException("Can only be set when the server is not running");
        }
        this.ioWorker = ioWorker;
    }

    public void setBossWorkerCount(Optional<Integer> bossWorker) {
        if (this.started) {
            throw new IllegalStateException("Can only be set when the server is not running");
        }
        this.bossWorker = bossWorker;
    }

    public synchronized void bind() throws Exception {
        if (this.started) {
            throw new IllegalStateException("Server running already");
        }
        if (this.addresses.isEmpty()) {
            throw new RuntimeException("Please specify at least on socketaddress to which the server should get bound!");
        }
        ServerBootstrap bootstrap = new ServerBootstrap();
        if (this.useEpoll) {
            bootstrap.channel(EpollServerSocketChannel.class);
            this.bossGroup = this.bossWorker.map(count -> new EpollEventLoopGroup(count.intValue(), (ThreadFactory)NamedThreadFactory.withName((String)(this.jmxName + "-boss"))));
            this.workerGroup = new EpollEventLoopGroup(this.ioWorker, (ThreadFactory)NamedThreadFactory.withName((String)(this.jmxName + "-io")));
        } else {
            bootstrap.channel(NioServerSocketChannel.class);
            this.bossGroup = this.bossWorker.map(count -> new NioEventLoopGroup(count.intValue(), (ThreadFactory)NamedThreadFactory.withName((String)(this.jmxName + "-boss"))));
            this.workerGroup = new NioEventLoopGroup(this.ioWorker, (ThreadFactory)NamedThreadFactory.withName((String)(this.jmxName + "-io")));
        }
        this.bossGroup.map(boss -> () -> bootstrap.group(boss, this.workerGroup)).orElse(() -> bootstrap.group(this.workerGroup)).run();
        ChannelInitializer<SocketChannel> factory = this.createPipelineFactory();
        bootstrap.childHandler(factory);
        this.configureBootstrap(bootstrap);
        for (InetSocketAddress address : this.addresses) {
            Channel channel = bootstrap.bind((SocketAddress)address).sync().channel();
            this.channels.add((Object)channel);
        }
        this.started = true;
    }

    protected void configureBootstrap(ServerBootstrap bootstrap) {
        bootstrap.option(ChannelOption.SO_BACKLOG, (Object)this.backlog);
        bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)true);
        bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)true);
    }

    public synchronized void unbind() {
        LOGGER.trace("Unbinding service: {}", (Object)this);
        if (!this.started) {
            return;
        }
        ArrayList<Object> futures = new ArrayList<Object>();
        this.bossGroup.ifPresent(boss -> futures.add(boss.shutdownGracefully()));
        if (this.workerGroup != null) {
            futures.add(this.workerGroup.shutdownGracefully(500L, 3000L, TimeUnit.MILLISECONDS));
        }
        futures.add(this.channels.close());
        if (this.gracefulShutdown) {
            Flux.fromIterable(futures).flatMap(future -> Mono.fromRunnable((Runnable)Throwing.runnable(() -> ((Future)future).await()).sneakyThrow())).then().block();
        }
        this.started = false;
    }

    public synchronized List<InetSocketAddress> getListenAddresses() {
        return (List)this.channels.stream().map(channel -> (InetSocketAddress)channel.localAddress()).collect(ImmutableList.toImmutableList());
    }

    protected abstract ChannelInitializer<SocketChannel> createPipelineFactory();

    public void setTimeout(int timeout) {
        if (this.started) {
            throw new IllegalStateException("Can only be set when the server is not running");
        }
        this.timeout = timeout;
    }

    public void setBacklog(int backlog) {
        if (this.started) {
            throw new IllegalStateException("Can only be set when the server is not running");
        }
        this.backlog = backlog;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean isBound() {
        return this.started;
    }
}

