/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.tokens;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.tokens.StringType;
import org.apache.jena.riot.tokens.TokenType;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.riot.tokens.TokenizerText;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.graph.NodeConst;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.sparql.util.NodeUtils;

public final class Token {
    private TokenType tokenType = null;
    private String tokenImage = null;
    private String tokenImage2 = null;
    private Token subToken1 = null;
    private Token subToken2 = null;
    private StringType stringType = null;
    private long column;
    private long line;
    public static final String ImageANY = "ANY";
    public static final String ImageTrue = "true";
    public static final String ImageFalse = "false";
    static final String delim1 = "";
    static final String delim2 = "";
    private static final String dtXSDintger = XSDDatatype.XSDinteger.getURI();
    private static final String dtXSDdecimal = XSDDatatype.XSDdecimal.getURI();
    private static final String dtXSDdouble = XSDDatatype.XSDdouble.getURI();

    public final TokenType getType() {
        return this.tokenType;
    }

    public final String getImage() {
        return this.tokenImage;
    }

    public final String getImage2() {
        return this.tokenImage2;
    }

    public final Token getSubToken1() {
        return this.subToken1;
    }

    public final Token getSubToken2() {
        return this.subToken2;
    }

    public final StringType getStringType() {
        return this.stringType;
    }

    public final boolean hasStringType(StringType st) {
        return this.stringType == st;
    }

    public final boolean isLongString() {
        switch (this.stringType) {
            case LONG_STRING1: 
            case LONG_STRING2: {
                return true;
            }
        }
        return false;
    }

    public final Token setType(TokenType tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    public final Token setImage(String tokenImage) {
        this.tokenImage = tokenImage;
        return this;
    }

    public final Token setImage(char tokenImage) {
        this.tokenImage = String.valueOf(tokenImage);
        return this;
    }

    public final Token setImage2(String tokenImage2) {
        this.tokenImage2 = tokenImage2;
        return this;
    }

    public final Token setSubToken1(Token subToken) {
        this.subToken1 = subToken;
        return this;
    }

    public final Token setSubToken2(Token subToken) {
        this.subToken2 = subToken;
        return this;
    }

    public final Token setStringType(StringType st) {
        this.stringType = st;
        return this;
    }

    static Token create(String s) {
        Tokenizer tt = TokenizerText.create().fromString(s).build();
        if (!tt.hasNext()) {
            throw new RiotException("No token");
        }
        Token t = tt.next();
        if (tt.hasNext()) {
            throw new RiotException("Extraneous characters");
        }
        return t;
    }

    public long getColumn() {
        return this.column;
    }

    public long getLine() {
        return this.line;
    }

    public Token(String string) {
        this(TokenType.STRING, string);
    }

    public Token(TokenType type) {
        this(type, null, null);
    }

    public Token(TokenType type, String image1) {
        this(type, image1, null);
    }

    public Token(TokenType type, String image1, String image2) {
        this();
        this.setType(type);
        this.setImage(image1);
        this.setImage2(image2);
    }

    private Token(TokenType type, String image1, String image2, Token subToken1, Token subToken2) {
        this();
        this.setType(type);
        this.setImage(image1);
        this.setImage2(image2);
        this.setSubToken1(subToken1);
        this.setSubToken2(subToken2);
    }

    private Token() {
        this(-1L, -1L);
    }

    public Token(long line, long column) {
        this.line = line;
        this.column = column;
    }

    public Token(Token token) {
        this(token.tokenType, token.tokenImage, token.tokenImage2, token.subToken1, token.subToken2);
        this.line = token.line;
        this.column = token.column;
    }

    public String asString() {
        switch (this.tokenType) {
            case STRING: {
                return this.getImage();
            }
        }
        return null;
    }

    public int asInt() {
        if (!this.hasType(TokenType.INTEGER)) {
            return -1;
        }
        return Integer.valueOf(this.tokenImage);
    }

    public long asLong() {
        return this.asLong(-1L);
    }

    public long asLong(long dft) {
        switch (this.tokenType) {
            case INTEGER: {
                return Long.valueOf(this.tokenImage);
            }
            case HEX: {
                return Long.valueOf(this.tokenImage, 16);
            }
        }
        return dft;
    }

    public String asWord() {
        if (!this.hasType(TokenType.KEYWORD)) {
            return null;
        }
        return this.tokenImage;
    }

    public String text() {
        return this.toString(false);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean addLocation) {
        StringBuilder sb = new StringBuilder();
        if (addLocation && this.getLine() >= 0L && this.getColumn() >= 0L) {
            sb.append(String.format("[%d,%d]", this.getLine(), this.getColumn()));
        }
        sb.append("[");
        if (this.getType() == null) {
            sb.append("null");
        } else {
            sb.append(this.getType().toString());
        }
        if (this.getImage() != null) {
            sb.append(":");
            sb.append("");
            sb.append(this.getImage());
            sb.append("");
        }
        if (this.getImage2() != null) {
            sb.append(":");
            sb.append("");
            sb.append(this.getImage2());
            sb.append("");
        }
        if (this.getSubToken1() != null) {
            sb.append(";");
            sb.append("");
            sb.append(this.getSubToken1().toString());
            sb.append("");
        }
        if (this.getSubToken2() != null) {
            sb.append(";");
            sb.append("");
            sb.append(this.getSubToken2().toString());
            sb.append("");
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean isEOF() {
        return this.tokenType == TokenType.EOF;
    }

    public boolean isWord() {
        return this.tokenType == TokenType.KEYWORD;
    }

    public boolean isString() {
        return this.tokenType == TokenType.STRING;
    }

    public boolean isNumber() {
        switch (this.tokenType) {
            case INTEGER: 
            case DECIMAL: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }

    public boolean isNode() {
        switch (this.tokenType) {
            case STRING: 
            case INTEGER: 
            case DECIMAL: 
            case DOUBLE: 
            case BNODE: 
            case IRI: 
            case PREFIXED_NAME: 
            case LITERAL_DT: 
            case LITERAL_LANG: {
                return true;
            }
            case KEYWORD: {
                return this.tokenImage.equals(ImageANY);
            }
        }
        return false;
    }

    public boolean isNodeBasic() {
        switch (this.tokenType) {
            case BNODE: 
            case IRI: 
            case PREFIXED_NAME: 
            case LITERAL_DT: 
            case LITERAL_LANG: {
                return true;
            }
            case STRING: {
                switch (this.stringType) {
                    case STRING1: 
                    case STRING2: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public boolean isBasicLiteral() {
        switch (this.tokenType) {
            case STRING: 
            case LITERAL_DT: 
            case LITERAL_LANG: {
                return true;
            }
        }
        return false;
    }

    public boolean isInteger() {
        return this.tokenType.equals((Object)TokenType.INTEGER);
    }

    public boolean isIRI() {
        return this.tokenType.equals((Object)TokenType.IRI) || this.tokenType.equals((Object)TokenType.PREFIXED_NAME);
    }

    public boolean isBNode() {
        return this.tokenType.equals((Object)TokenType.BNODE);
    }

    public Node asNode() {
        return this.asNode(null);
    }

    public Node asNode(PrefixMap pmap) {
        switch (this.tokenType) {
            case BNODE: {
                return NodeFactory.createBlankNode(this.tokenImage);
            }
            case IRI: {
                return NodeFactory.createURI(this.tokenImage);
            }
            case PREFIXED_NAME: {
                if (pmap == null) {
                    return NodeFactory.createURI("urn:prefixed-name:" + this.tokenImage + ":" + this.tokenImage2);
                }
                String x = pmap.expand(this.tokenImage, this.tokenImage2);
                if (x == null) {
                    throw new RiotException("Can't expand prefixed name: " + String.valueOf(this));
                }
                return NodeFactory.createURI(x);
            }
            case DECIMAL: {
                return NodeFactory.createLiteralDT(this.tokenImage, XSDDatatype.XSDdecimal);
            }
            case DOUBLE: {
                return NodeFactory.createLiteralDT(this.tokenImage, XSDDatatype.XSDdouble);
            }
            case INTEGER: {
                return NodeFactory.createLiteralDT(this.tokenImage, XSDDatatype.XSDinteger);
            }
            case LITERAL_DT: {
                Token lexToken = this.getSubToken1();
                Token dtToken = this.getSubToken2();
                if (pmap == null && dtToken.hasType(TokenType.PREFIXED_NAME)) {
                    throw new RiotException("Invalid token: " + String.valueOf(this));
                }
                Node n = dtToken.asNode(pmap);
                if (!n.isURI()) {
                    throw new RiotException("Invalid token: " + String.valueOf(this));
                }
                RDFDatatype dt = TypeMapper.getInstance().getSafeTypeByName(n.getURI());
                return NodeFactory.createLiteralDT(lexToken.getImage(), dt);
            }
            case LITERAL_LANG: {
                return NodeFactory.createLiteralLang(this.tokenImage, this.tokenImage2);
            }
            case STRING: {
                return NodeFactory.createLiteralString(this.tokenImage);
            }
            case VAR: {
                return Var.alloc(this.tokenImage);
            }
            case KEYWORD: {
                if (this.tokenImage.equals(ImageANY)) {
                    return NodeConst.nodeANY;
                }
                if (this.tokenImage.equals(ImageTrue)) {
                    return NodeConst.nodeTrue;
                }
                if (!this.tokenImage.equals(ImageFalse)) break;
                return NodeConst.nodeFalse;
            }
        }
        return null;
    }

    public boolean hasType(TokenType tokenType) {
        return this.getType() == tokenType;
    }

    public int hashCode() {
        return Lib.hashCodeObject((Object)this.tokenType) ^ Lib.hashCodeObject(this.tokenImage) ^ Lib.hashCodeObject(this.tokenImage2);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Token)) {
            return false;
        }
        Token t = (Token)other;
        return Objects.equals((Object)this.tokenType, (Object)t.tokenType) && Objects.equals(this.tokenImage, t.tokenImage) && Objects.equals(this.tokenImage2, t.tokenImage2);
    }

    public static Token tokenForInteger(long value) {
        return new Token(TokenType.INTEGER, Long.toString(value));
    }

    public static Token tokenForWord(String word) {
        return new Token(TokenType.KEYWORD, word);
    }

    public static Token tokenForNode(Node n) {
        return Token.tokenForNode(n, null, null);
    }

    public static Token tokenForNode(Node node, String base, PrefixMap mapping) {
        if (node.isURI()) {
            String x;
            Pair<String, String> pname;
            String uri = node.getURI();
            if (mapping != null && (pname = mapping.abbrev(uri)) != null) {
                return new Token(TokenType.PREFIXED_NAME, pname.getLeft(), pname.getRight());
            }
            if (base != null && (x = FmtUtils.abbrevByBase(uri, base)) != null) {
                return new Token(TokenType.IRI, x);
            }
            return new Token(TokenType.IRI, node.getURI());
        }
        if (node.isBlank()) {
            return new Token(TokenType.BNODE, node.getBlankNodeLabel());
        }
        if (node.isVariable()) {
            return new Token(TokenType.VAR, node.getName());
        }
        if (node.isLiteral()) {
            if (NodeUtils.isSimpleString(node)) {
                String lex = node.getLiteralLexicalForm();
                return new Token(TokenType.STRING, lex);
            }
            if (NodeUtils.isLangString(node)) {
                String lex = node.getLiteralLexicalForm();
                Token sub1 = new Token(TokenType.STRING, lex);
                String lang = node.getLiteralLanguage();
                return new Token(TokenType.LITERAL_LANG, lex, lang, sub1, null);
            }
            String datatype = node.getLiteralDatatypeURI();
            String s = node.getLiteralLexicalForm();
            if (datatype.equals(dtXSDintger)) {
                try {
                    String s1 = s;
                    if (s.startsWith("+")) {
                        s1 = s.substring(1);
                    }
                    new BigInteger(s1);
                    return new Token(TokenType.INTEGER, s);
                }
                catch (NumberFormatException s1) {
                    // empty catch block
                }
            }
            if (datatype.equals(dtXSDdecimal) && s.indexOf(46) > 0) {
                try {
                    new BigDecimal(s);
                    return new Token(TokenType.DECIMAL, s);
                }
                catch (NumberFormatException s1) {
                    // empty catch block
                }
            }
            if (datatype.equals(dtXSDdouble) && (s.indexOf(101) >= 0 || s.indexOf(69) >= 0)) {
                try {
                    Double.parseDouble(s);
                    return new Token(TokenType.DOUBLE, s);
                }
                catch (NumberFormatException s1) {
                    // empty catch block
                }
            }
            Node dt = NodeFactory.createURI(datatype);
            Token subToken1 = new Token(TokenType.STRING, s);
            Token subToken2 = Token.tokenForNode(dt);
            Token t = new Token(TokenType.LITERAL_DT, s);
            t.setSubToken1(subToken1);
            t.setSubToken2(subToken2);
            return t;
        }
        if (node.equals(Node.ANY)) {
            return new Token(TokenType.KEYWORD, ImageANY);
        }
        throw new IllegalArgumentException();
    }
}

