/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.store.value;

import java.math.BigDecimal;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.jena.atlas.lib.BitsInt;
import org.apache.jena.atlas.lib.BitsLong;
import org.apache.jena.atlas.lib.NumberUtils;
import org.apache.jena.ext.xerces.DatatypeFactoryInst;

public class DateTimeNode {
    static final int DATE_LEN = 22;
    static final int TIME_LEN = 27;
    static final int MILLI = 0;
    static final int MILLI_LEN = 16;
    static final int MINUTES = 16;
    static final int MINUTES_LEN = 6;
    static final int HOUR = 22;
    static final int HOUR_LEN = 5;
    static final int DAY = 27;
    static final int DAY_LEN = 5;
    static final int MONTH = 32;
    static final int MONTH_LEN = 4;
    static final int YEAR = 36;
    static final int YEAR_LEN = 13;
    static final int TZ = 49;
    static final int TZ_LEN = 7;
    static final int TZ_Z = 127;
    static final int TZ_NONE = 126;
    static DatatypeFactory datatypeFactory = DatatypeFactoryInst.newDatatypeFactory();

    static long time(long v, int hour, int mins, int millisec) {
        v = BitsLong.pack(v, hour, 22, 27);
        v = BitsLong.pack(v, mins, 16, 22);
        v = BitsLong.pack(v, millisec, 0, 16);
        return v;
    }

    static long date(long v, int year, int month, int day) {
        v = BitsLong.pack(v, year, 36, 49);
        v = BitsLong.pack(v, month, 32, 36);
        v = BitsLong.pack(v, day, 27, 32);
        return v;
    }

    static long tz(long v, int tz_in_quarters) {
        v = BitsLong.pack(v, tz_in_quarters, 49, 56);
        return v;
    }

    public static long packDate(String lex) {
        return DateTimeNode.packDateTime(lex);
    }

    public static long packDateTime(String lex) {
        try {
            return DateTimeNode.packDateTime$(lex);
        }
        catch (Exception ex) {
            return -1L;
        }
    }

    private static long packDateTime$(String lex) {
        BigDecimal fs;
        long v = 0L;
        boolean containsZ = (lex = lex.trim()).indexOf(90) > 0;
        XMLGregorianCalendar xcal = datatypeFactory.newXMLGregorianCalendar(lex);
        if (xcal.getFractionalSecond() != null && (fs = xcal.getFractionalSecond()).doubleValue() != (double)xcal.getMillisecond() / 1000.0) {
            return -1L;
        }
        int y = xcal.getYear();
        if (y < 0 || y >= 8000) {
            return -1L;
        }
        v = DateTimeNode.date(v, xcal.getYear(), xcal.getMonth(), xcal.getDay());
        v = DateTimeNode.time(v, xcal.getHour(), xcal.getMinute(), xcal.getSecond() * 1000 + xcal.getMillisecond());
        if (containsZ) {
            return DateTimeNode.tz(v, 127);
        }
        int tz = xcal.getTimezone();
        if (tz == Integer.MIN_VALUE) {
            return DateTimeNode.tz(v, 126);
        }
        if (tz % 15 != 0) {
            return -1L;
        }
        return DateTimeNode.tz(v, tz /= 15);
    }

    public static String unpackDateTime(long v) {
        return DateTimeNode.unpack(v, true);
    }

    public static String unpackDate(long v) {
        return DateTimeNode.unpack(v, false);
    }

    private static String unpack(long v, boolean isDateTime) {
        int years = (int)BitsLong.unpack(v, 36, 49);
        int months = (int)BitsLong.unpack(v, 32, 36);
        int days = (int)BitsLong.unpack(v, 27, 32);
        int hours = (int)BitsLong.unpack(v, 22, 27);
        int minutes = (int)BitsLong.unpack(v, 16, 22);
        int milliSeconds = (int)BitsLong.unpack(v, 0, 16);
        int tz = (int)BitsLong.unpack(v, 49, 56);
        int sec2 = milliSeconds / 1000;
        int fractionSec = milliSeconds % 1000;
        StringBuilder sb = new StringBuilder(50);
        NumberUtils.formatInt(sb, years, 4);
        sb.append('-');
        NumberUtils.formatInt(sb, months, 2);
        sb.append('-');
        NumberUtils.formatInt(sb, days, 2);
        if (isDateTime) {
            sb.append('T');
            NumberUtils.formatInt(sb, hours, 2);
            sb.append(':');
            NumberUtils.formatInt(sb, minutes, 2);
            sb.append(':');
            NumberUtils.formatInt(sb, sec2, 2);
            if (fractionSec != 0) {
                sb.append(".");
                if (fractionSec % 100 == 0) {
                    NumberUtils.formatInt(sb, fractionSec / 100, 1);
                } else if (fractionSec % 10 == 0) {
                    NumberUtils.formatInt(sb, fractionSec / 10, 2);
                } else {
                    NumberUtils.formatInt(sb, fractionSec, 3);
                }
            }
        }
        if (tz == 127) {
            sb.append("Z");
            return sb.toString();
        }
        if (tz == 126) {
            return sb.toString();
        }
        if (BitsLong.isSet(v, 55)) {
            tz = BitsInt.set(tz, 7, 32);
        }
        if (tz < 0) {
            tz = -tz;
            sb.append('-');
        } else {
            sb.append('+');
        }
        int tzH = tz / 4;
        int tzM = tz % 4 * 15;
        NumberUtils.formatUnsignedInt(sb, tzH, 2);
        sb.append(':');
        NumberUtils.formatUnsignedInt(sb, tzM, 2);
        return sb.toString();
    }
}

