/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.servlets;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Objects;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.pathmap.PathSpecSet;
import org.eclipse.jetty.util.IncludeExclude;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IncludeExcludeBasedFilter
implements Filter {
    private final IncludeExclude<String> _mimeTypes = new IncludeExclude();
    private final IncludeExclude<String> _httpMethods = new IncludeExclude();
    private final IncludeExclude<String> _paths = new IncludeExclude(PathSpecSet.class);
    private static final Logger LOG = LoggerFactory.getLogger(IncludeExcludeBasedFilter.class);

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        String includedPaths = filterConfig.getInitParameter("includedPaths");
        String excludedPaths = filterConfig.getInitParameter("excludedPaths");
        String includedMimeTypes = filterConfig.getInitParameter("includedMimeTypes");
        String excludedMimeTypes = filterConfig.getInitParameter("excludedMimeTypes");
        String includedHttpMethods = filterConfig.getInitParameter("includedHttpMethods");
        String excludedHttpMethods = filterConfig.getInitParameter("excludedHttpMethods");
        if (includedPaths != null) {
            this._paths.include((T[])StringUtil.csvSplit(includedPaths));
        }
        if (excludedPaths != null) {
            this._paths.exclude((T[])StringUtil.csvSplit(excludedPaths));
        }
        if (includedMimeTypes != null) {
            this._mimeTypes.include((T[])StringUtil.csvSplit(includedMimeTypes));
        }
        if (excludedMimeTypes != null) {
            this._mimeTypes.exclude((T[])StringUtil.csvSplit(excludedMimeTypes));
        }
        if (includedHttpMethods != null) {
            this._httpMethods.include((T[])StringUtil.csvSplit(includedHttpMethods));
        }
        if (excludedHttpMethods != null) {
            this._httpMethods.exclude((T[])StringUtil.csvSplit(excludedHttpMethods));
        }
    }

    protected String guessMimeType(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        String mimeType;
        String contentType = httpResponse.getContentType();
        LOG.debug("Content Type is: {}", (Object)contentType);
        if (contentType != null) {
            mimeType = MimeTypes.getContentTypeWithoutCharset(contentType);
            LOG.debug("Mime Type is: {}", (Object)mimeType);
        } else {
            String requestUrl = httpRequest.getPathInfo();
            mimeType = Objects.requireNonNullElse(httpRequest.getServletContext().getMimeType(requestUrl), "");
            LOG.debug("Guessed mime type is {}", (Object)mimeType);
        }
        return mimeType;
    }

    protected boolean shouldFilter(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        String httpMethod = httpRequest.getMethod();
        LOG.debug("HTTP method is: {}", (Object)httpMethod);
        if (!this._httpMethods.test(httpMethod)) {
            LOG.debug("should not apply filter because HTTP method does not match");
            return false;
        }
        String mimeType = this.guessMimeType(httpRequest, httpResponse);
        if (!this._mimeTypes.test(mimeType)) {
            LOG.debug("should not apply filter because mime type does not match");
            return false;
        }
        ServletContext context2 = httpRequest.getServletContext();
        String path = context2 == null ? httpRequest.getRequestURI() : URIUtil.addPaths(httpRequest.getServletPath(), httpRequest.getPathInfo());
        LOG.debug("Path is: {}", (Object)path);
        if (!this._paths.test(path)) {
            LOG.debug("should not apply filter because path does not match");
            return false;
        }
        return true;
    }

    @Override
    public void destroy() {
    }

    public String toString() {
        return "filter configuration:\npaths:\n" + String.valueOf(this._paths) + "\nmime types:\n" + String.valueOf(this._mimeTypes) + "\nhttp methods:\n" + String.valueOf(this._httpMethods);
    }
}

