/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet;

import java.util.Arrays;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;

public class FacetField
extends Field {
    public static final FieldType TYPE = new FieldType();
    public final String dim;
    public final String[] path;

    public FacetField(String dim, String ... path) {
        super("dummy", TYPE);
        FacetField.verifyLabel(dim);
        for (String label : path) {
            FacetField.verifyLabel(label);
        }
        this.dim = dim;
        if (path.length == 0) {
            throw new IllegalArgumentException("path must have at least one element");
        }
        this.path = path;
    }

    @Override
    public String toString() {
        return "FacetField(dim=" + this.dim + " path=" + Arrays.toString(this.path) + ")";
    }

    public static void verifyLabel(String label) {
        if (label == null || label.isEmpty()) {
            throw new IllegalArgumentException("empty or null components not allowed; got: " + label);
        }
    }
}

