/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.share;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.requests.ShareFetchRequest;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.server.share.CachedSharePartition;
import org.apache.kafka.server.share.LastUsedKey;
import org.apache.kafka.server.share.ShareSessionKey;

public class ShareSession {
    private final ShareSessionKey key;
    private final ImplicitLinkedHashCollection<CachedSharePartition> partitionMap;
    private final long creationMs;
    private long lastUsedMs;
    public int epoch;
    private int cachedSize = -1;

    public ShareSession(ShareSessionKey key, ImplicitLinkedHashCollection<CachedSharePartition> partitionMap, long creationMs, long lastUsedMs, int epoch) {
        this.key = key;
        this.partitionMap = partitionMap;
        this.creationMs = creationMs;
        this.lastUsedMs = lastUsedMs;
        this.epoch = epoch;
    }

    public ShareSessionKey key() {
        return this.key;
    }

    public synchronized int cachedSize() {
        return this.cachedSize;
    }

    public synchronized void cachedSize(int size) {
        this.cachedSize = size;
    }

    public synchronized long lastUsedMs() {
        return this.lastUsedMs;
    }

    public synchronized void lastUsedMs(long ts) {
        this.lastUsedMs = ts;
    }

    public synchronized ImplicitLinkedHashCollection<CachedSharePartition> partitionMap() {
        return this.partitionMap;
    }

    public synchronized int epoch() {
        return this.epoch;
    }

    public synchronized int size() {
        return this.partitionMap.size();
    }

    public synchronized Boolean isEmpty() {
        return this.partitionMap.isEmpty();
    }

    public synchronized LastUsedKey lastUsedKey() {
        return new LastUsedKey(this.key, this.lastUsedMs);
    }

    public synchronized long creationMs() {
        return this.creationMs;
    }

    public synchronized Map<ModifiedTopicIdPartitionType, List<TopicIdPartition>> update(Map<TopicIdPartition, ShareFetchRequest.SharePartitionData> shareFetchData, List<TopicIdPartition> toForget) {
        ArrayList added = new ArrayList();
        ArrayList updated = new ArrayList();
        ArrayList removed = new ArrayList();
        shareFetchData.forEach((topicIdPartition, sharePartitionData) -> {
            CachedSharePartition cachedSharePartitionKey = new CachedSharePartition((TopicIdPartition)topicIdPartition, (ShareFetchRequest.SharePartitionData)sharePartitionData, true);
            CachedSharePartition cachedPart = (CachedSharePartition)this.partitionMap.find((ImplicitLinkedHashCollection.Element)cachedSharePartitionKey);
            if (cachedPart == null) {
                this.partitionMap.mustAdd((ImplicitLinkedHashCollection.Element)cachedSharePartitionKey);
                added.add(topicIdPartition);
            } else {
                cachedPart.updateRequestParams((ShareFetchRequest.SharePartitionData)sharePartitionData);
                updated.add(topicIdPartition);
            }
        });
        toForget.forEach(topicIdPartition -> {
            if (this.partitionMap.remove((Object)new CachedSharePartition((TopicIdPartition)topicIdPartition))) {
                removed.add(topicIdPartition);
            }
        });
        HashMap<ModifiedTopicIdPartitionType, List<TopicIdPartition>> result = new HashMap<ModifiedTopicIdPartitionType, List<TopicIdPartition>>();
        result.put(ModifiedTopicIdPartitionType.ADDED, added);
        result.put(ModifiedTopicIdPartitionType.UPDATED, updated);
        result.put(ModifiedTopicIdPartitionType.REMOVED, removed);
        return result;
    }

    public String toString() {
        return "ShareSession(key=" + this.key + ", partitionMap=" + this.partitionMap + ", creationMs=" + this.creationMs + ", lastUsedMs=" + this.lastUsedMs + ", epoch=" + this.epoch + ", cachedSize=" + this.cachedSize + ")";
    }

    public static enum ModifiedTopicIdPartitionType {
        ADDED,
        UPDATED,
        REMOVED;

    }
}

