/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql;

import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.mybatis.dynamic.sql.ConditionVisitor;
import org.mybatis.dynamic.sql.VisitableCondition;

public abstract class AbstractTwoValueCondition<T>
implements VisitableCondition<T> {
    protected final T value1;
    protected final T value2;

    protected AbstractTwoValueCondition(T value1, T value2) {
        this.value1 = value1;
        this.value2 = value2;
    }

    public T value1() {
        return this.value1;
    }

    public T value2() {
        return this.value2;
    }

    @Override
    public <R> R accept(ConditionVisitor<T, R> visitor) {
        return visitor.visit(this);
    }

    protected <S extends AbstractTwoValueCondition<T>> S filterSupport(BiPredicate<? super T, ? super T> predicate, Supplier<S> emptySupplier, S self) {
        if (this.shouldRender()) {
            return (S)(predicate.test(this.value1, this.value2) ? self : (AbstractTwoValueCondition)emptySupplier.get());
        }
        return self;
    }

    protected <S extends AbstractTwoValueCondition<T>> S filterSupport(Predicate<? super T> predicate, Supplier<S> emptySupplier, S self) {
        return this.filterSupport((? super T v1, ? super T v2) -> predicate.test(v1) && predicate.test(v2), emptySupplier, self);
    }

    protected <R, S extends AbstractTwoValueCondition<R>> S mapSupport(Function<? super T, ? extends R> mapper1, Function<? super T, ? extends R> mapper2, BiFunction<R, R, S> constructor, Supplier<S> emptySupplier) {
        if (this.shouldRender()) {
            return (S)((AbstractTwoValueCondition)constructor.apply(mapper1.apply(this.value1), mapper2.apply(this.value2)));
        }
        return (S)((AbstractTwoValueCondition)emptySupplier.get());
    }

    public abstract AbstractTwoValueCondition<T> filter(BiPredicate<? super T, ? super T> var1);

    public abstract AbstractTwoValueCondition<T> filter(Predicate<? super T> var1);

    public abstract String renderCondition(String var1, String var2, String var3);
}

