/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.common;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.mybatis.dynamic.sql.SqlCriterion;
import org.mybatis.dynamic.sql.common.AbstractBooleanExpressionModel;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.render.TableAliasCalculator;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;
import org.mybatis.dynamic.sql.util.FragmentCollector;
import org.mybatis.dynamic.sql.util.StringUtilities;
import org.mybatis.dynamic.sql.where.render.CriterionRenderer;
import org.mybatis.dynamic.sql.where.render.RenderedCriterion;

public abstract class AbstractBooleanExpressionRenderer<M extends AbstractBooleanExpressionModel> {
    protected final M model;
    private final String prefix;
    private final CriterionRenderer criterionRenderer;

    protected AbstractBooleanExpressionRenderer(String prefix, AbstractBuilder<M, ?> builder) {
        this.model = Objects.requireNonNull((AbstractBooleanExpressionModel)((AbstractBuilder)builder).model);
        this.prefix = Objects.requireNonNull(prefix);
        this.criterionRenderer = new CriterionRenderer.Builder().withSequence(((AbstractBuilder)builder).sequence).withRenderingStrategy(((AbstractBuilder)builder).renderingStrategy).withTableAliasCalculator(((AbstractBuilder)builder).tableAliasCalculator).withParameterName(((AbstractBuilder)builder).parameterName).build();
    }

    public Optional<FragmentAndParameters> render() {
        return ((AbstractBooleanExpressionModel)this.model).initialCriterion().map(this::renderWithInitialCriterion).orElseGet(this::renderWithoutInitialCriterion).map(rc -> FragmentAndParameters.withFragment(rc.fragmentAndParameters().fragment()).withParameters(rc.fragmentAndParameters().parameters()).build());
    }

    private Optional<RenderedCriterion> renderWithInitialCriterion(SqlCriterion initialCriterion) {
        return this.criterionRenderer.render(initialCriterion, ((AbstractBooleanExpressionModel)this.model).subCriteria(), this::calculateClause);
    }

    private Optional<RenderedCriterion> renderWithoutInitialCriterion() {
        return this.criterionRenderer.render(((AbstractBooleanExpressionModel)this.model).subCriteria(), this::calculateClause);
    }

    private String calculateClause(FragmentCollector collector) {
        if (collector.hasMultipleFragments()) {
            return collector.fragments().collect(Collectors.joining(" ", StringUtilities.spaceAfter(this.prefix), ""));
        }
        return collector.firstFragment().map(this::stripEnclosingParenthesesIfPresent).map(this::addPrefix).orElse("");
    }

    private String stripEnclosingParenthesesIfPresent(String fragment) {
        if (fragment.startsWith("(") && fragment.endsWith(")")) {
            return fragment.substring(1, fragment.length() - 1);
        }
        return fragment;
    }

    private String addPrefix(String fragment) {
        return StringUtilities.spaceAfter(this.prefix) + fragment;
    }

    public static abstract class AbstractBuilder<M, B extends AbstractBuilder<M, B>> {
        private final M model;
        private RenderingStrategy renderingStrategy;
        private TableAliasCalculator tableAliasCalculator;
        private AtomicInteger sequence;
        private String parameterName;

        protected AbstractBuilder(M model) {
            this.model = model;
        }

        public B withRenderingStrategy(RenderingStrategy renderingStrategy) {
            this.renderingStrategy = renderingStrategy;
            return this.getThis();
        }

        public B withTableAliasCalculator(TableAliasCalculator tableAliasCalculator) {
            this.tableAliasCalculator = tableAliasCalculator;
            return this.getThis();
        }

        public B withSequence(AtomicInteger sequence) {
            this.sequence = sequence;
            return this.getThis();
        }

        public B withParameterName(String parameterName) {
            this.parameterName = parameterName;
            return this.getThis();
        }

        protected abstract B getThis();
    }
}

