/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.SortSpecification;
import org.mybatis.dynamic.sql.common.OrderByModel;
import org.mybatis.dynamic.sql.configuration.StatementConfiguration;
import org.mybatis.dynamic.sql.select.PagingModel;
import org.mybatis.dynamic.sql.select.QueryExpressionDSL;
import org.mybatis.dynamic.sql.select.QueryExpressionModel;
import org.mybatis.dynamic.sql.select.SelectModel;
import org.mybatis.dynamic.sql.util.Buildable;
import org.mybatis.dynamic.sql.util.ConfigurableStatement;

public class SelectDSL<R>
implements Buildable<R>,
ConfigurableStatement<SelectDSL<R>> {
    private final Function<SelectModel, R> adapterFunction;
    private final List<QueryExpressionDSL<R>> queryExpressions = new ArrayList<QueryExpressionDSL<R>>();
    private OrderByModel orderByModel;
    private Long limit;
    private Long offset;
    private Long fetchFirstRows;

    private SelectDSL(Function<SelectModel, R> adapterFunction) {
        this.adapterFunction = Objects.requireNonNull(adapterFunction);
    }

    public static QueryExpressionDSL.FromGatherer<SelectModel> select(BasicColumn ... selectList2) {
        return SelectDSL.select(Arrays.asList(selectList2));
    }

    public static QueryExpressionDSL.FromGatherer<SelectModel> select(Collection<BasicColumn> selectList2) {
        return SelectDSL.select(Function.identity(), selectList2);
    }

    public static <R> QueryExpressionDSL.FromGatherer<R> select(Function<SelectModel, R> adapterFunction, BasicColumn ... selectList2) {
        return SelectDSL.select(adapterFunction, Arrays.asList(selectList2));
    }

    public static <R> QueryExpressionDSL.FromGatherer<R> select(Function<SelectModel, R> adapterFunction, Collection<BasicColumn> selectList2) {
        return new QueryExpressionDSL.FromGatherer.Builder().withSelectList(selectList2).withSelectDSL(new SelectDSL<R>(adapterFunction)).build();
    }

    public static QueryExpressionDSL.FromGatherer<SelectModel> selectDistinct(BasicColumn ... selectList2) {
        return SelectDSL.selectDistinct(Function.identity(), selectList2);
    }

    public static QueryExpressionDSL.FromGatherer<SelectModel> selectDistinct(Collection<BasicColumn> selectList2) {
        return SelectDSL.selectDistinct(Function.identity(), selectList2);
    }

    public static <R> QueryExpressionDSL.FromGatherer<R> selectDistinct(Function<SelectModel, R> adapterFunction, BasicColumn ... selectList2) {
        return SelectDSL.selectDistinct(adapterFunction, Arrays.asList(selectList2));
    }

    public static <R> QueryExpressionDSL.FromGatherer<R> selectDistinct(Function<SelectModel, R> adapterFunction, Collection<BasicColumn> selectList2) {
        return new QueryExpressionDSL.FromGatherer.Builder().withSelectList(selectList2).withSelectDSL(new SelectDSL<R>(adapterFunction)).isDistinct().build();
    }

    void registerQueryExpression(QueryExpressionDSL<R> queryExpression) {
        this.queryExpressions.add(queryExpression);
    }

    void orderBy(Collection<SortSpecification> columns) {
        this.orderByModel = OrderByModel.of(columns);
    }

    public LimitFinisher limit(long limit) {
        this.limit = limit;
        return new LimitFinisher();
    }

    public OffsetFirstFinisher offset(long offset) {
        this.offset = offset;
        return new OffsetFirstFinisher();
    }

    public FetchFirstFinisher fetchFirst(long fetchFirstRows) {
        this.fetchFirstRows = fetchFirstRows;
        return new FetchFirstFinisher();
    }

    @Override
    public SelectDSL<R> configureStatement(Consumer<StatementConfiguration> consumer) {
        this.queryExpressions.forEach(q -> q.configureStatement((Consumer)consumer));
        return this;
    }

    @Override
    @NotNull
    public R build() {
        SelectModel selectModel = SelectModel.withQueryExpressions(this.buildModels()).withOrderByModel(this.orderByModel).withPagingModel(this.buildPagingModel()).build();
        return this.adapterFunction.apply(selectModel);
    }

    private List<QueryExpressionModel> buildModels() {
        return this.queryExpressions.stream().map(QueryExpressionDSL::buildModel).collect(Collectors.toList());
    }

    private PagingModel buildPagingModel() {
        if (this.limit == null && this.offset == null && this.fetchFirstRows == null) {
            return null;
        }
        return new PagingModel.Builder().withLimit(this.limit).withOffset(this.offset).withFetchFirstRows(this.fetchFirstRows).build();
    }

    public class LimitFinisher
    implements Buildable<R> {
        public OffsetFinisher offset(long offset) {
            SelectDSL.this.offset(offset);
            return new OffsetFinisher();
        }

        @Override
        @NotNull
        public R build() {
            return SelectDSL.this.build();
        }
    }

    public class OffsetFirstFinisher
    implements Buildable<R> {
        public FetchFirstFinisher fetchFirst(long fetchFirstRows) {
            SelectDSL.this.fetchFirst(fetchFirstRows);
            return new FetchFirstFinisher();
        }

        @Override
        @NotNull
        public R build() {
            return SelectDSL.this.build();
        }
    }

    public class FetchFirstFinisher {
        public RowsOnlyFinisher rowsOnly() {
            return new RowsOnlyFinisher();
        }
    }

    public class RowsOnlyFinisher
    implements Buildable<R> {
        @Override
        @NotNull
        public R build() {
            return SelectDSL.this.build();
        }
    }

    public class OffsetFinisher
    implements Buildable<R> {
        @Override
        @NotNull
        public R build() {
            return SelectDSL.this.build();
        }
    }
}

