/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.util.spring;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.mybatis.dynamic.sql.delete.DeleteModel;
import org.mybatis.dynamic.sql.delete.render.DeleteStatementProvider;
import org.mybatis.dynamic.sql.insert.BatchInsertModel;
import org.mybatis.dynamic.sql.insert.GeneralInsertModel;
import org.mybatis.dynamic.sql.insert.InsertModel;
import org.mybatis.dynamic.sql.insert.MultiRowInsertModel;
import org.mybatis.dynamic.sql.insert.render.BatchInsert;
import org.mybatis.dynamic.sql.insert.render.GeneralInsertStatementProvider;
import org.mybatis.dynamic.sql.insert.render.InsertStatementProvider;
import org.mybatis.dynamic.sql.insert.render.MultiRowInsertStatementProvider;
import org.mybatis.dynamic.sql.render.RenderingStrategies;
import org.mybatis.dynamic.sql.select.SelectModel;
import org.mybatis.dynamic.sql.select.render.SelectStatementProvider;
import org.mybatis.dynamic.sql.update.UpdateModel;
import org.mybatis.dynamic.sql.update.render.UpdateStatementProvider;
import org.mybatis.dynamic.sql.util.Buildable;
import org.mybatis.dynamic.sql.util.spring.BatchInsertUtility;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.KeyHolder;

public class NamedParameterJdbcTemplateExtensions {
    private final NamedParameterJdbcTemplate template;

    public NamedParameterJdbcTemplateExtensions(NamedParameterJdbcTemplate template) {
        this.template = Objects.requireNonNull(template);
    }

    public long count(Buildable<SelectModel> countStatement) {
        return this.count(countStatement.build().render(RenderingStrategies.SPRING_NAMED_PARAMETER));
    }

    public long count(SelectStatementProvider countStatement) {
        return (Long)this.template.queryForObject(countStatement.getSelectStatement(), countStatement.getParameters(), Long.class);
    }

    public int delete(Buildable<DeleteModel> deleteStatement) {
        return this.delete(deleteStatement.build().render(RenderingStrategies.SPRING_NAMED_PARAMETER));
    }

    public int delete(DeleteStatementProvider deleteStatement) {
        return this.template.update(deleteStatement.getDeleteStatement(), deleteStatement.getParameters());
    }

    public int generalInsert(Buildable<GeneralInsertModel> insertStatement) {
        return this.generalInsert(insertStatement.build().render(RenderingStrategies.SPRING_NAMED_PARAMETER));
    }

    public int generalInsert(GeneralInsertStatementProvider insertStatement) {
        return this.template.update(insertStatement.getInsertStatement(), insertStatement.getParameters());
    }

    public int generalInsert(Buildable<GeneralInsertModel> insertStatement, KeyHolder keyHolder) {
        return this.generalInsert(insertStatement.build().render(RenderingStrategies.SPRING_NAMED_PARAMETER), keyHolder);
    }

    public int generalInsert(GeneralInsertStatementProvider insertStatement, KeyHolder keyHolder) {
        return this.template.update(insertStatement.getInsertStatement(), (SqlParameterSource)new MapSqlParameterSource(insertStatement.getParameters()), keyHolder);
    }

    public <T> int insert(Buildable<InsertModel<T>> insertStatement) {
        return this.insert(insertStatement.build().render(RenderingStrategies.SPRING_NAMED_PARAMETER));
    }

    public <T> int insert(InsertStatementProvider<T> insertStatement) {
        return this.template.update(insertStatement.getInsertStatement(), (SqlParameterSource)new BeanPropertySqlParameterSource(insertStatement));
    }

    public <T> int insert(Buildable<InsertModel<T>> insertStatement, KeyHolder keyHolder) {
        return this.insert(insertStatement.build().render(RenderingStrategies.SPRING_NAMED_PARAMETER), keyHolder);
    }

    public <T> int insert(InsertStatementProvider<T> insertStatement, KeyHolder keyHolder) {
        return this.template.update(insertStatement.getInsertStatement(), (SqlParameterSource)new BeanPropertySqlParameterSource(insertStatement), keyHolder);
    }

    public <T> int[] insertBatch(Buildable<BatchInsertModel<T>> insertStatement) {
        return this.insertBatch(insertStatement.build().render(RenderingStrategies.SPRING_NAMED_PARAMETER));
    }

    public <T> int[] insertBatch(BatchInsert<T> insertStatement) {
        return this.template.batchUpdate(insertStatement.getInsertStatementSQL(), BatchInsertUtility.createBatch(insertStatement.getRecords()));
    }

    public <T> int insertMultiple(Buildable<MultiRowInsertModel<T>> insertStatement) {
        return this.insertMultiple(insertStatement.build().render(RenderingStrategies.SPRING_NAMED_PARAMETER));
    }

    public <T> int insertMultiple(MultiRowInsertStatementProvider<T> insertStatement) {
        return this.template.update(insertStatement.getInsertStatement(), (SqlParameterSource)new BeanPropertySqlParameterSource(insertStatement));
    }

    public <T> int insertMultiple(Buildable<MultiRowInsertModel<T>> insertStatement, KeyHolder keyHolder) {
        return this.insertMultiple(insertStatement.build().render(RenderingStrategies.SPRING_NAMED_PARAMETER), keyHolder);
    }

    public <T> int insertMultiple(MultiRowInsertStatementProvider<T> insertStatement, KeyHolder keyHolder) {
        return this.template.update(insertStatement.getInsertStatement(), (SqlParameterSource)new BeanPropertySqlParameterSource(insertStatement), keyHolder);
    }

    public <T> List<T> selectList(Buildable<SelectModel> selectStatement, RowMapper<T> rowMapper) {
        return this.selectList(selectStatement.build().render(RenderingStrategies.SPRING_NAMED_PARAMETER), rowMapper);
    }

    public <T> List<T> selectList(SelectStatementProvider selectStatement, RowMapper<T> rowMapper) {
        return this.template.query(selectStatement.getSelectStatement(), selectStatement.getParameters(), rowMapper);
    }

    public <T> Optional<T> selectOne(Buildable<SelectModel> selectStatement, RowMapper<T> rowMapper) {
        return this.selectOne(selectStatement.build().render(RenderingStrategies.SPRING_NAMED_PARAMETER), rowMapper);
    }

    public <T> Optional<T> selectOne(SelectStatementProvider selectStatement, RowMapper<T> rowMapper) {
        Object result;
        try {
            result = this.template.queryForObject(selectStatement.getSelectStatement(), selectStatement.getParameters(), rowMapper);
        }
        catch (EmptyResultDataAccessException e) {
            result = null;
        }
        return Optional.ofNullable(result);
    }

    public int update(Buildable<UpdateModel> updateStatement) {
        return this.update(updateStatement.build().render(RenderingStrategies.SPRING_NAMED_PARAMETER));
    }

    public int update(UpdateStatementProvider updateStatement) {
        return this.template.update(updateStatement.getUpdateStatement(), updateStatement.getParameters());
    }
}

