/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

public class QueryTrace {
    public static final String HTTP_RECEPTION = "HTTP_RECEPTION";
    public static final String GET_ACL_INFO = "GET_ACL_INFO";
    public static final String SQL_TRANSFORMATION = "SQL_TRANSFORMATION";
    public static final String SQL_PARSE_AND_OPTIMIZE = "SQL_PARSE_AND_OPTIMIZE";
    public static final String MODEL_MATCHING = "MODEL_MATCHING";
    public static final String PREPARE_AND_SUBMIT_JOB = "PREPARE_AND_SUBMIT_JOB";
    public static final String WAIT_FOR_EXECUTION = "WAIT_FOR_EXECUTION";
    public static final String EXECUTION = "EXECUTION";
    public static final String FETCH_RESULT = "FETCH_RESULT";
    public static final String SPARK_JOB_EXECUTION = "SPARK_JOB_EXECUTION";
    public static final String SQL_PUSHDOWN_TRANSFORMATION = "SQL_PUSHDOWN_TRANSFORMATION";
    public static final String HIT_CACHE = "HIT_CACHE";
    static final String PREPARATION = "PREPARATION";
    static final String JOB_EXECUTION = "JOB_EXECUTION";
    public static final Map<String, String> SPAN_GROUPS = new HashMap<String, String>();
    private List<Span> spans = new LinkedList<Span>();

    public Optional<Span> getLastSpan() {
        return this.spans.isEmpty() ? Optional.empty() : Optional.of(this.spans.get(this.spans.size() - 1));
    }

    public void endLastSpan() {
        this.getLastSpan().ifPresent(span -> {
            if (span.duration == -1L) {
                span.duration = System.currentTimeMillis() - span.start;
            }
        });
    }

    public void startSpan(String name) {
        this.endLastSpan();
        this.spans.add(new Span(name, System.currentTimeMillis()));
    }

    public void appendSpan(String name, long duration) {
        this.spans.add(new Span(name, this.getLastSpan().map(span -> span.getStart() + span.getDuration()).orElse(System.currentTimeMillis()), duration));
    }

    public void appendSpanFromRequest(String name, long duration) {
        this.spans.add(new Span(name, 0L, duration));
    }

    public void amendLast(String name, long endAt) {
        for (int i = this.spans.size() - 1; i >= 0; --i) {
            if (!this.spans.get((int)i).name.equals(name)) continue;
            this.spans.get((int)i).duration = endAt - this.spans.get((int)i).start;
            return;
        }
    }

    public long calculateDuration(String name, long endAt) {
        for (int i = this.spans.size() - 1; i >= 0; --i) {
            if (!this.spans.get((int)i).name.equals(name)) continue;
            long duration = endAt - this.spans.get((int)i).start;
            return duration;
        }
        return -1L;
    }

    public void setDuration(String name, long duration) {
        for (int i = this.spans.size() - 1; i >= 0; --i) {
            if (!this.spans.get((int)i).name.equals(name)) continue;
            this.spans.get((int)i).duration = duration;
        }
    }

    public void clear() {
        this.spans = new LinkedList<Span>();
    }

    public List<Span> spans() {
        return this.spans;
    }

    @Generated
    public List<Span> getSpans() {
        return this.spans;
    }

    static {
        SPAN_GROUPS.put(GET_ACL_INFO, PREPARATION);
        SPAN_GROUPS.put(SQL_TRANSFORMATION, PREPARATION);
        SPAN_GROUPS.put(SQL_PARSE_AND_OPTIMIZE, PREPARATION);
        SPAN_GROUPS.put(MODEL_MATCHING, PREPARATION);
        SPAN_GROUPS.put(PREPARE_AND_SUBMIT_JOB, JOB_EXECUTION);
        SPAN_GROUPS.put(WAIT_FOR_EXECUTION, JOB_EXECUTION);
        SPAN_GROUPS.put(EXECUTION, JOB_EXECUTION);
        SPAN_GROUPS.put(FETCH_RESULT, JOB_EXECUTION);
    }

    public static class Span {
        String name;
        String group;
        long start;
        long duration = -1L;

        public Span(String name, long start, long duration) {
            this.name = name;
            this.start = start;
            this.duration = duration;
            this.group = SPAN_GROUPS.get(name);
        }

        public Span(String name, long start) {
            this.name = name;
            this.start = start;
            this.group = SPAN_GROUPS.get(name);
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getGroup() {
            return this.group;
        }

        @Generated
        public long getStart() {
            return this.start;
        }

        @Generated
        public long getDuration() {
            return this.duration;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setGroup(String group) {
            this.group = group;
        }

        @Generated
        public void setStart(long start) {
            this.start = start;
        }

        @Generated
        public void setDuration(long duration) {
            this.duration = duration;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Span)) {
                return false;
            }
            Span other = (Span)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$group = this.getGroup();
            String other$group = other.getGroup();
            if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
                return false;
            }
            if (this.getStart() != other.getStart()) {
                return false;
            }
            return this.getDuration() == other.getDuration();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Span;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $group = this.getGroup();
            result = result * 59 + ($group == null ? 43 : $group.hashCode());
            long $start = this.getStart();
            result = result * 59 + (int)($start >>> 32 ^ $start);
            long $duration = this.getDuration();
            result = result * 59 + (int)($duration >>> 32 ^ $duration);
            return result;
        }

        @Generated
        public String toString() {
            return "QueryTrace.Span(name=" + this.getName() + ", group=" + this.getGroup() + ", start=" + this.getStart() + ", duration=" + this.getDuration() + ")";
        }

        @Generated
        public Span() {
        }
    }
}

