/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common;

import java.util.Locale;
import org.apache.kylin.common.KapConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadFsSwitch {
    private static final Logger logger = LoggerFactory.getLogger(ReadFsSwitch.class);
    static volatile boolean fsOrFsBackup = false;
    static volatile long fsBackupCount = 0L;
    static volatile long resetMillis = 0L;

    public static String select(String fileSystem, String fileSystemBackup) {
        if (resetMillis > 0L && System.currentTimeMillis() > resetMillis) {
            fsOrFsBackup = false;
            resetMillis = 0L;
            logger.info("Backup read FS is back to off, switch=" + fsOrFsBackup);
        }
        if (fsOrFsBackup) {
            if (fsBackupCount++ % 100L == 0L) {
                logger.info("Returning backup read FS: " + fileSystemBackup + "  (empty means the origin working-dir)");
            }
            return fileSystemBackup;
        }
        return fileSystem;
    }

    public static void turnOnBackupFsWhile() {
        if (!fsOrFsBackup && resetMillis == 0L) {
            fsOrFsBackup = true;
            fsBackupCount = 0L;
            int sec = KapConfig.getInstanceFromEnv().getParquetReadFileSystemBackupResetSec();
            resetMillis = System.currentTimeMillis() + 1000L * (long)sec;
            logger.info("Backup read FS is on for {} sec, switch={}", (Object)sec, (Object)fsOrFsBackup);
        }
    }

    public static boolean turnOnSwitcherIfBackupFsAllowed(Throwable ex, String backupFsAllowedStrings) {
        if (!fsOrFsBackup && resetMillis == 0L) {
            while (ex != null) {
                String exceptionClassName = ex.getClass().getName().toLowerCase(Locale.ROOT);
                String msg = ex.getMessage() != null ? ex.getMessage().toLowerCase(Locale.ROOT) : "";
                for (String backupFsAllowedString : backupFsAllowedStrings.split(",")) {
                    if (exceptionClassName.contains(backupFsAllowedString) || msg.contains(backupFsAllowedString)) {
                        ReadFsSwitch.turnOnBackupFsWhile();
                        return true;
                    }
                    ex = ex.getCause();
                }
            }
        }
        return false;
    }
}

