/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.exception;

import java.io.Serializable;
import java.util.Collection;
import java.util.Locale;
import lombok.Generated;
import org.apache.kylin.common.exception.ErrorCode;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;

public class KylinException
extends RuntimeException
implements Serializable {
    public static final String CODE_SUCCESS = "000";
    public static final String CODE_UNAUTHORIZED = "401";
    public static final String CODE_UNDEFINED = "999";
    private final ErrorCode errorCode;
    private final String code;
    private Object data;
    private boolean throwTrace = true;
    private transient ErrorCodeProducer errorCodeProducer;
    private transient Object[] args;

    public KylinException(ErrorCodeSupplier errorCodeSupplier, String msg) {
        super(msg);
        this.errorCode = errorCodeSupplier.toErrorCode();
        this.code = CODE_UNDEFINED;
    }

    public KylinException(ErrorCodeSupplier errorCodeSupplier, String msg, boolean throwTrace) {
        super(msg);
        this.errorCode = errorCodeSupplier.toErrorCode();
        this.code = CODE_UNDEFINED;
        this.throwTrace = throwTrace;
    }

    public KylinException(ErrorCodeSupplier errorCodeSupplier, Throwable cause) {
        this(errorCodeSupplier, cause.getMessage(), cause);
    }

    public KylinException(ErrorCodeSupplier errorCodeSupplier, String msg, Throwable cause) {
        super(msg, cause);
        this.errorCode = errorCodeSupplier.toErrorCode();
        this.code = CODE_UNDEFINED;
    }

    public KylinException(ErrorCodeSupplier errorCodeSupplier, String msg, Collection<? extends Throwable> causes) {
        super(msg);
        this.errorCode = errorCodeSupplier.toErrorCode();
        this.code = CODE_UNDEFINED;
        causes.forEach(this::addSuppressed);
    }

    public KylinException(ErrorCodeSupplier errorCodeSupplier, String msg, String code) {
        super(msg);
        this.errorCode = errorCodeSupplier.toErrorCode();
        this.code = code;
    }

    public KylinException(ErrorCodeSupplier errorCodeSupplier, String msg, String code, Throwable cause) {
        super(msg, cause);
        this.errorCode = errorCodeSupplier.toErrorCode();
        this.code = code;
    }

    public KylinException(ErrorCodeProducer errorCodeProducer, Object ... args) {
        super(errorCodeProducer.getMsg(args));
        this.errorCode = new ErrorCode(errorCodeProducer.getErrorCode().getCode());
        this.code = CODE_UNDEFINED;
        this.args = args;
        this.errorCodeProducer = errorCodeProducer;
    }

    public KylinException(ErrorCodeProducer errorCodeProducer, Throwable cause, Object ... args) {
        super(errorCodeProducer.getMsg(args), cause);
        this.errorCode = new ErrorCode(errorCodeProducer.getErrorCode().getCode());
        this.code = CODE_UNDEFINED;
        this.args = args;
        this.errorCodeProducer = errorCodeProducer;
    }

    public String getSuggestionString() {
        return this.errorCodeProducer == null ? null : this.errorCodeProducer.getErrorSuggest().getLocalizedString();
    }

    public String getErrorCodeString() {
        return this.errorCodeProducer == null ? this.errorCode.getCodeString() : this.errorCodeProducer.getErrorCode().getCode();
    }

    public KylinException withData(Object data) {
        this.data = data;
        return this;
    }

    @Override
    public String toString() {
        if (this.errorCodeProducer != null) {
            return this.errorCodeProducer.getCodeMsg(this.args);
        }
        return String.join((CharSequence)" \n", this.errorCode.getString(), super.toString());
    }

    @Override
    public String getLocalizedMessage() {
        if (this.errorCodeProducer != null) {
            return this.errorCodeProducer.getCodeMsg(this.args);
        }
        return String.format(Locale.ROOT, "%s%s", this.errorCode.getLocalizedString(), super.getLocalizedMessage());
    }

    @Generated
    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public Object getData() {
        return this.data;
    }

    @Generated
    public boolean isThrowTrace() {
        return this.throwTrace;
    }

    @Generated
    public ErrorCodeProducer getErrorCodeProducer() {
        return this.errorCodeProducer;
    }

    @Generated
    public Object[] getArgs() {
        return this.args;
    }
}

