/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.hystrix;

import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.hystrix.NBreakerConfig;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NCircuitBreaker {
    private static final Logger logger = LoggerFactory.getLogger(NCircuitBreaker.class);
    private static final AtomicBoolean breakerStarted = new AtomicBoolean(false);
    private static volatile NBreakerConfig breakerConfig = null;

    private NCircuitBreaker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start(KapConfig verifiableProps) {
        AtomicBoolean atomicBoolean = breakerStarted;
        synchronized (atomicBoolean) {
            if (!breakerStarted.get()) {
                try {
                    breakerConfig = new NBreakerConfig(verifiableProps);
                    breakerStarted.set(true);
                    logger.info("circuit-breaker started");
                }
                catch (Exception e) {
                    logger.error("circuit-breaker start failed", (Throwable)e);
                }
            }
        }
    }

    @VisibleForTesting
    public static void stop() {
        breakerStarted.set(false);
        logger.info("circuit-breaker stopped");
    }

    public static void verifyProjectCreation(int current) {
        if (!NCircuitBreaker.isEnabled()) {
            return;
        }
        int threshold = breakerConfig.thresholdOfProject();
        if (threshold < 1 || current < threshold) {
            return;
        }
        throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FAILED_CREATE_PROJECT, String.format(Locale.ROOT, MsgPicker.getMsg().getProjectNumOverThreshold(), threshold));
    }

    public static void verifyModelCreation(int current) {
        if (!NCircuitBreaker.isEnabled()) {
            return;
        }
        int threshold = breakerConfig.thresholdOfModel();
        if (threshold < 1 || current < threshold) {
            return;
        }
        throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FAILED_CREATE_MODEL, String.format(Locale.ROOT, MsgPicker.getMsg().getModelNumOverThreshold(), threshold));
    }

    public static void verifyQueryResultRowCount(long current) {
        if (!NCircuitBreaker.isEnabled()) {
            return;
        }
        long threshold = breakerConfig.thresholdOfQueryResultRowCount();
        if (threshold < 1L || current <= threshold) {
            return;
        }
        throw new KylinException((ErrorCodeProducer)ErrorCodeServer.QUERY_RESULT_OBTAIN_FAILED, threshold);
    }

    private static boolean isEnabled() {
        if (!breakerStarted.get()) {
            logger.warn("circuit-breaker not started");
            return false;
        }
        return breakerConfig.isBreakerEnabled();
    }
}

