/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.lock;

import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.apache.kylin.common.lock.DistributedLockFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalLockFactory
extends DistributedLockFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalLockFactory.class);
    private static final HashMap<String, ReentrantLock> cache = new HashMap();

    @Override
    public Lock getLockForClient(String client, String lockId) {
        return this.getLockInternal(client, lockId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lock getLockInternal(String client, String lockId) {
        HashMap<String, ReentrantLock> hashMap = cache;
        synchronized (hashMap) {
            cache.putIfAbsent(lockId, new ReentrantLock());
            ReentrantLock lock = cache.get(lockId);
            return new LocalLock(lock, client, lockId);
        }
    }

    @Override
    public void initialize() {
    }

    private static class LocalLock
    implements Lock {
        private ReentrantLock lock;
        private String client;
        private String lockId;

        @Override
        public void lock() {
            log.debug(this.client + " locking " + this.lockId);
            this.lock.lock();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            this.lock.lockInterruptibly();
        }

        @Override
        public boolean tryLock() {
            return this.lock.tryLock();
        }

        @Override
        public boolean tryLock(long l, TimeUnit timeUnit) throws InterruptedException {
            return this.lock.tryLock(l, timeUnit);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unlock() {
            HashMap hashMap = cache;
            synchronized (hashMap) {
                log.debug(this.client + " unlocking " + this.lockId);
                this.lock.unlock();
                cache.remove(this.lockId);
            }
        }

        @Override
        public Condition newCondition() {
            return this.lock.newCondition();
        }

        @Generated
        public LocalLock(ReentrantLock lock, String client, String lockId) {
            this.lock = lock;
            this.client = client;
            this.lockId = lockId;
        }
    }
}

