/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.logging;

import java.io.Closeable;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.ThreadContext;
import org.springframework.util.CollectionUtils;

public class SetLogCategory
implements Closeable {
    private static final String LOG_CATEGORY = "logCategory";
    private static final ThreadLocal<Deque<String>> categoryThreadLocal = ThreadLocal.withInitial(LinkedList::new);

    public SetLogCategory(String category) {
        String oldCategory = ThreadContext.get((String)LOG_CATEGORY);
        ThreadContext.put((String)LOG_CATEGORY, (String)category);
        if (StringUtils.isNotBlank((CharSequence)oldCategory)) {
            categoryThreadLocal.get().offerFirst(oldCategory);
        }
    }

    @Override
    public void close() {
        String oldCategory;
        ThreadContext.remove((String)LOG_CATEGORY);
        if (!CollectionUtils.isEmpty((Collection)categoryThreadLocal.get()) && StringUtils.isNotBlank((CharSequence)(oldCategory = categoryThreadLocal.get().pollFirst()))) {
            ThreadContext.put((String)LOG_CATEGORY, (String)oldCategory);
        }
    }
}

