/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.TombRawResource;
import org.apache.kylin.common.persistence.resources.LayoutRawResource;
import org.apache.kylin.common.util.Unsafe;
import org.apache.log4j.Logger;

public class RawResourceFilter {
    @Generated
    private static final Logger log = Logger.getLogger(RawResourceFilter.class);
    final List<Condition> conditions;
    static final HashMap<Class<? extends RawResource>, HashMap<String, Function<RawResource, Object>>> FUNCTION_MAP = new HashMap();

    public RawResourceFilter() {
        this(new ArrayList<Condition>());
    }

    public RawResourceFilter(List<Condition> conditions) {
        this.conditions = conditions;
    }

    public RawResourceFilter addConditions(Condition condition) {
        this.conditions.add(condition);
        return this;
    }

    public RawResourceFilter addConditions(String name, List<Object> values, Operator op) {
        this.conditions.add(new Condition(name, values, op));
        return this;
    }

    public boolean isMatch(RawResource rawResource) {
        if (rawResource instanceof TombRawResource) {
            return true;
        }
        for (Condition condition : this.conditions) {
            if (this.checkCondition(condition, rawResource)) continue;
            return false;
        }
        return true;
    }

    private boolean checkCondition(Condition condition, RawResource rawResource) {
        Object value;
        switch (condition.name) {
            case "metaKey": {
                value = rawResource.getMetaKey();
                break;
            }
            case "uuid": {
                value = rawResource.getUuid();
                break;
            }
            case "project": {
                value = rawResource.getProject();
                break;
            }
            case "mvcc": {
                value = rawResource.getMvcc();
                break;
            }
            case "ts": {
                value = rawResource.getTs();
                break;
            }
            case "reservedFiled1": {
                value = rawResource.getReservedFiled1();
                break;
            }
            case "reservedFiled2": {
                value = rawResource.getReservedFiled2();
                break;
            }
            case "reservedFiled3": {
                value = rawResource.getReservedFiled3();
                break;
            }
            case "id": 
            case "content": {
                throw new IllegalArgumentException("id & content field can't be used as filter condition");
            }
            default: {
                value = this.getCustomValue(rawResource, condition.name);
            }
        }
        if (value != null) {
            switch (condition.getOp()) {
                case EQUAL: {
                    return Objects.equals(condition.values.get(0), value);
                }
                case EQUAL_CASE_INSENSITIVE: {
                    assert (value instanceof String) : "[" + Condition.access$000(condition) + "] '" + value + "' is not String, can't compare case insensitive";
                    return ((String)value).equalsIgnoreCase((String)condition.values.get(0));
                }
                case LIKE_CASE_INSENSITIVE: {
                    assert (value instanceof String) : "[" + Condition.access$000(condition) + "] '" + value + "' is not String, can't compare like case insensitive";
                    return StringUtils.containsIgnoreCase((CharSequence)((String)value), (CharSequence)((String)condition.values.get(0)));
                }
                case IN: {
                    return condition.values.contains(value);
                }
                case GT: {
                    assert (value instanceof Long);
                    return (Long)value > (Long)condition.values.get(0);
                }
                case LT: {
                    assert (value instanceof Long);
                    return (Long)value < (Long)condition.values.get(0);
                }
                case LE: {
                    assert (value instanceof Long);
                    return (Long)value <= (Long)condition.values.get(0);
                }
                case GE: {
                    assert (value instanceof Long);
                    return (Long)value >= (Long)condition.values.get(0);
                }
            }
            throw new UnsupportedOperationException("Operator not supported:" + (Object)((Object)condition.getOp()));
        }
        return false;
    }

    private Object getCustomValue(RawResource raw, String attr) {
        Function<RawResource, Object> fun;
        HashMap<String, Function<RawResource, Object>> method_map = FUNCTION_MAP.get(raw.getClass());
        if (method_map != null && (fun = method_map.get(attr)) != null) {
            return fun.apply(raw);
        }
        try {
            Field field = raw.getClass().getDeclaredField(attr);
            Unsafe.changeAccessibleObject(field, true);
            return field.get(raw);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalArgumentException("Invalid condition:" + attr, e);
        }
    }

    public static RawResourceFilter equalFilter(String key, String value) {
        return RawResourceFilter.simpleFilter(Operator.EQUAL, key, value);
    }

    public static RawResourceFilter simpleFilter(Operator op, String key, Object value) {
        return new RawResourceFilter().addConditions(key, Collections.singletonList(value), op);
    }

    @Generated
    public List<Condition> getConditions() {
        return this.conditions;
    }

    static {
        FUNCTION_MAP.put(LayoutRawResource.class, new HashMap());
        FUNCTION_MAP.get(LayoutRawResource.class).put("dataflowId", raw -> ((LayoutRawResource)raw).getDataflowId());
    }

    public static enum Operator {
        EQUAL,
        EQUAL_CASE_INSENSITIVE,
        IN,
        GT,
        LT,
        LIKE_CASE_INSENSITIVE,
        LE,
        GE;

    }

    public static class Condition {
        private final String name;
        private final List<Object> values;
        private final Operator op;
        private String eval;

        public Condition(String name, List<Object> values, Operator op) {
            this(name, values, op, null);
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public List<Object> getValues() {
            return this.values;
        }

        @Generated
        public Operator getOp() {
            return this.op;
        }

        @Generated
        public String getEval() {
            return this.eval;
        }

        @Generated
        public Condition(String name, List<Object> values, Operator op, String eval) {
            this.name = name;
            this.values = values;
            this.op = op;
            this.eval = eval;
        }

        @Generated
        public void setEval(String eval) {
            this.eval = eval;
        }
    }
}

