/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence.metadata;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.persistence.AuditLog;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.UnitMessages;
import org.apache.kylin.common.persistence.transaction.AbstractAuditLogReplayWorker;

public interface AuditLogStore
extends Closeable {
    public void save(UnitMessages var1);

    public List<AuditLog> fetch(long var1, long var3);

    public List<AuditLog> fetch(List<Long> var1);

    public long getMaxId();

    public long getMinId();

    public long getLogOffset();

    public void restore(long var1);

    public void rotate();

    default public void catchupWithTimeout() throws TimeoutException {
        ResourceStore store = ResourceStore.getKylinMetaStore(this.getConfig());
        this.getReplayWorker().catchupFrom(store.getOffset());
        this.getReplayWorker().waitForCatchup(this.getMaxId(), this.getConfig().getCatchUpTimeout());
    }

    default public void catchupWithTimeoutInNewThread() {
        Thread catchupThread = new Thread(() -> {
            try {
                this.catchupWithTimeout();
            }
            catch (TimeoutException e) {
                throw new KylinRuntimeException(e);
            }
        });
        catchupThread.start();
        try {
            catchupThread.join();
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
    }

    default public void catchupWithMaxTimeout() throws TimeoutException {
        ResourceStore store = ResourceStore.getKylinMetaStore(this.getConfig());
        this.getReplayWorker().catchupFrom(store.getOffset());
        this.getReplayWorker().waitForCatchup(this.getMaxId(), this.getConfig().getCatchUpMaxTimeout());
    }

    default public void catchup() {
        ResourceStore store = ResourceStore.getKylinMetaStore(this.getConfig());
        this.getReplayWorker().catchupFrom(store.getOffset());
    }

    public void setInstance(String var1);

    public AuditLog get(String var1, long var2);

    default public void pause() {
        this.getReplayWorker().close(true);
    }

    default public void reInit() {
        ResourceStore store = ResourceStore.getKylinMetaStore(this.getConfig());
        this.getReplayWorker().reStartSchedule(store.getOffset());
    }

    public long count(long var1, long var3);

    public AbstractAuditLogReplayWorker getReplayWorker();

    public KylinConfig getConfig();

    @Override
    default public void close() throws IOException {
        this.getReplayWorker().close(false);
    }
}

