/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence.metadata;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Map;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.ibatis.logging.nologging.NoLoggingImpl;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.type.JdbcType;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.RawResourceFilter;
import org.apache.kylin.common.persistence.metadata.mapper.BasicMapper;
import org.apache.kylin.common.persistence.metadata.mapper.BasicSqlTable;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.mybatis.dynamic.sql.AndOrCriteriaGroup;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.SqlBuilder;
import org.mybatis.dynamic.sql.VisitableCondition;
import org.mybatis.dynamic.sql.select.QueryExpressionDSL;
import org.mybatis.dynamic.sql.select.SelectDSLCompleter;
import org.mybatis.dynamic.sql.where.condition.IsEqualTo;
import org.mybatis.spring.transaction.SpringManagedTransactionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataMapperFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetadataMapperFactory.class);

    private MetadataMapperFactory() {
    }

    public static <T extends RawResource> BasicMapper<T> createFor(MetadataType type, SqlSession session) {
        return (BasicMapper)session.getMapper(MetadataMapperFactory.getMapperClass(type));
    }

    public static SqlSessionFactory getSqlSessionFactory(DataSource dataSource) throws SQLException, IOException, ClassNotFoundException {
        log.info("Start to build SqlSessionFactory");
        SpringManagedTransactionFactory transactionFactory = new SpringManagedTransactionFactory();
        Environment environment = new Environment("kylin metadata store", (TransactionFactory)transactionFactory, dataSource);
        Configuration configuration = new Configuration(environment);
        configuration.setUseGeneratedKeys(true);
        configuration.setJdbcTypeForNull(JdbcType.NULL);
        MetadataType.NEED_CACHED_METADATA.stream().filter(type -> type != MetadataType.TMP_REC).map(MetadataMapperFactory::getMapperClass).forEach(arg_0 -> ((Configuration)configuration).addMapper(arg_0));
        configuration.setCacheEnabled(false);
        configuration.setLogImpl(NoLoggingImpl.class);
        return new SqlSessionFactoryBuilder().build(configuration);
    }

    private static Class<BasicMapper<? extends RawResource>> getMapperClass(MetadataType type) {
        try {
            return Class.forName(BasicMapper.class.getPackage().getName() + "." + MetadataMapperFactory.snakeCaseToCamelCase(type.name().toLowerCase(Locale.ROOT), true) + "Mapper");
        }
        catch (ClassNotFoundException e) {
            throw new KylinRuntimeException("Cannot find mapper class for " + (Object)((Object)type), e);
        }
    }

    public static String snakeCaseToCamelCase(String snakeCase, boolean firstCharUpper) {
        StringBuilder sb = new StringBuilder(snakeCase.length() + 1);
        boolean capNext = firstCharUpper;
        for (int ctr = 0; ctr < snakeCase.length(); ++ctr) {
            char next = snakeCase.charAt(ctr);
            if (next == '_') {
                capNext = true;
                continue;
            }
            if (Character.isDigit(next)) {
                sb.append(next);
                capNext = true;
                continue;
            }
            if (capNext) {
                sb.append(Character.toUpperCase(next));
                capNext = false;
                continue;
            }
            if (ctr == 0) {
                sb.append(Character.toLowerCase(next));
                continue;
            }
            sb.append(next);
        }
        return sb.toString();
    }

    public static SelectDSLCompleter convertConditionsToDSLCompleter(RawResourceFilter filter, Map<String, BasicColumn> selectColumnMap) {
        if (filter == null || filter.getConditions().isEmpty()) {
            return SelectDSLCompleter.allRows();
        }
        return c -> {
            QueryExpressionDSL.QueryExpressionWhereBuilder stat = c.where();
            boolean firstCondition = true;
            for (RawResourceFilter.Condition condition : filter.getConditions()) {
                assert (condition.getOp() != null && condition.getValues() != null && !condition.getValues().isEmpty()) : "Invalid condition: " + condition;
                BindableColumn curColumn = (BindableColumn)selectColumnMap.get(condition.getName());
                if (curColumn != null) {
                    IsEqualTo vc = SqlBuilder.isEqualTo((Object)condition.getValues().get(0));
                    switch (condition.getOp()) {
                        case EQUAL: {
                            break;
                        }
                        case EQUAL_CASE_INSENSITIVE: {
                            curColumn = SqlBuilder.upper((BindableColumn)curColumn);
                            vc = SqlBuilder.isEqualTo((Object)condition.getValues().stream().map(String::valueOf).map(s -> s.toUpperCase(Locale.ROOT)).findFirst().orElse(""));
                            break;
                        }
                        case IN: {
                            vc = SqlBuilder.isIn(condition.getValues());
                            break;
                        }
                        case GT: {
                            vc = SqlBuilder.isGreaterThan((Object)condition.getValues().get(0));
                            break;
                        }
                        case LT: {
                            vc = SqlBuilder.isLessThan((Object)condition.getValues().get(0));
                            break;
                        }
                        case LIKE_CASE_INSENSITIVE: {
                            vc = SqlBuilder.isLikeCaseInsensitive((String)String.valueOf(condition.getValues().get(0)));
                            break;
                        }
                        case LE: {
                            vc = SqlBuilder.isLessThanOrEqualTo((Object)condition.getValues().get(0));
                            break;
                        }
                        case GE: {
                            vc = SqlBuilder.isGreaterThanOrEqualTo((Object)condition.getValues().get(0));
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException("Operator not supported: " + (Object)((Object)condition.getOp()));
                        }
                    }
                    if (firstCondition) {
                        stat = (QueryExpressionDSL.QueryExpressionWhereBuilder)c.where(curColumn, (VisitableCondition)vc, new AndOrCriteriaGroup[0]);
                        firstCondition = false;
                        continue;
                    }
                    stat.and(curColumn, (VisitableCondition)vc, new AndOrCriteriaGroup[0]);
                    continue;
                }
                throw new IllegalArgumentException("Invalid condition: " + condition);
            }
            return stat;
        };
    }

    public static void resetMapperTableNameIfNeed(StorageURL url, SqlSessionFactory factory) {
        Preconditions.checkArgument((boolean)"jdbc".equals(url.getScheme()));
        try (SqlSession session = factory.openSession();){
            MetadataType.NEED_CACHED_METADATA.stream().filter(type -> type != MetadataType.TMP_REC).forEach(type -> {
                BasicMapper mapper = MetadataMapperFactory.createFor(type, session);
                Object sqlTable = mapper.getSqlTable();
                String identifier = url.getIdentifier();
                if (!((BasicSqlTable)((Object)((Object)sqlTable))).getTableNamePrefix().equals(identifier)) {
                    String tableName = identifier + "_" + ((BasicSqlTable)((Object)((Object)sqlTable))).getTableNameSuffix();
                    log.warn("Reset the table name for metadata mapper: {}", (Object)tableName);
                    ((BasicSqlTable)((Object)((Object)sqlTable))).updateTableName();
                }
            });
        }
    }
}

