/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence.metadata.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.util.CompressionUtils;
import org.apache.kylin.guava30.shaded.common.io.ByteSource;
import org.springframework.jdbc.core.RowMapper;

public class RawResourceRowMapper
implements RowMapper<RawResource> {
    public RawResource mapRow(ResultSet rs, int rowNum) throws SQLException {
        String resPath = rs.getString(1);
        byte[] content = CompressionUtils.decompress(rs.getBytes(2));
        long ts = rs.getLong(3);
        long mvcc = rs.getLong(4);
        return new RawResource(resPath, ByteSource.wrap((byte[])content), ts, mvcc);
    }
}

