/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.scheduler.EventBusFactory;
import org.apache.kylin.common.util.Logger;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.ProcessUtils;
import org.apache.kylin.common.util.SSHClient;
import org.apache.kylin.common.util.SSHClientOutput;
import org.apache.kylin.common.util.ShellException;
import org.apache.kylin.common.util.StringBuilderHelper;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.slf4j.LoggerFactory;

public class CliCommandExecutor {
    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(CliCommandExecutor.class);
    private String remoteHost;
    private int port;
    private String remoteUser;
    private String remotePwd;
    private String localIdentityPath;
    private static final int REMOTE_TIMEOUT_SECONDS = 3600;

    public CliCommandExecutor() {
    }

    public CliCommandExecutor(String remoteHost, String remoteUser, String remotePwd) {
        this.remoteHost = remoteHost;
        this.remoteUser = remoteUser;
        this.remotePwd = remotePwd;
        this.port = 22;
    }

    public CliCommandExecutor(String remoteHost, String remoteUser, String remotePwd, String localIdentityPath, int port) {
        this.remoteHost = remoteHost;
        this.remoteUser = remoteUser;
        this.remotePwd = remotePwd;
        this.localIdentityPath = localIdentityPath;
        this.port = port;
    }

    public CliCommandExecutor(String remoteHost, String remoteUser, String remotePwd, String localIdentityPath) {
        this(remoteHost, remoteUser, remotePwd);
        this.localIdentityPath = localIdentityPath;
    }

    public void setRunAtRemote(String host, int port, String user, String pwd) {
        this.remoteHost = host;
        this.port = port;
        this.remoteUser = user;
        this.remotePwd = pwd;
    }

    public void setRunAtLocal() {
        this.remoteHost = null;
        this.remoteUser = null;
        this.remotePwd = null;
    }

    public void setLocalIdentityPath(String localIdentityPath) {
        this.localIdentityPath = localIdentityPath;
    }

    public void copyFile(String localFile, String destDir) throws IOException {
        if (this.remoteHost == null) {
            this.copyNative(localFile, destDir);
        } else {
            this.copyLocalToRemote(localFile, destDir);
        }
    }

    private void copyNative(String localFile, String destDir) throws IOException {
        File src = new File(localFile);
        File dest = new File(destDir, src.getName());
        FileUtils.copyFile((File)src, (File)dest);
    }

    private void copyLocalToRemote(String localFile, String destDir) throws IOException {
        SSHClient ssh = this.getSshClient();
        try {
            ssh.scpFileToRemote(localFile, destDir);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public void copyRemoteToLocal(String remoteFile, String destDir) throws IOException {
        SSHClient ssh = this.getSshClient();
        try {
            ssh.scpRemoteFileToLocal(remoteFile, destDir);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @VisibleForTesting
    public SSHClient getSshClient() {
        return new SSHClient(this.remoteHost, this.port, this.remoteUser, this.remotePwd, this.localIdentityPath);
    }

    public CliCmdExecResult execute(String command, Logger logAppender) throws ShellException {
        return this.execute(command, logAppender, null);
    }

    public CliCmdExecResult execute(String command, Logger logAppender, String jobId) throws ShellException {
        CliCmdExecResult r;
        if (this.remoteHost == null) {
            r = this.runNativeCommand(command, logAppender, jobId);
        } else {
            Pair<Integer, String> remoteResult = this.runRemoteCommand(command, logAppender);
            r = new CliCmdExecResult(remoteResult.getFirst(), remoteResult.getSecond(), null);
        }
        if (r.getCode() != 0) {
            throw new ShellException("OS command error exit with return code: " + r.getCode() + ", error message: " + r.getCmd() + "The command is: \n" + command + (this.remoteHost == null ? "" : " (remoteHost:" + this.remoteHost + ")"));
        }
        return r;
    }

    private Pair<Integer, String> runRemoteCommand(String command, Logger logAppender) throws ShellException {
        try {
            SSHClient ssh = this.getSshClient();
            SSHClientOutput sshOutput = ssh.execCommand(command, 3600, logAppender);
            int exitCode = sshOutput.getExitCode();
            String output = sshOutput.getText();
            return Pair.newPair(exitCode, output);
        }
        catch (Exception e) {
            throw new ShellException(e);
        }
    }

    private CliCmdExecResult runNativeCommand(String command, Logger logAppender, String jobId) throws ShellException {
        int pid = 0;
        try {
            Object[] cmd = new String[3];
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Windows")) {
                cmd[0] = "cmd.exe";
                cmd[1] = "/C";
            } else {
                cmd[0] = "/bin/bash";
                cmd[1] = "-c";
            }
            cmd[2] = command;
            ProcessBuilder builder = new ProcessBuilder((String[])cmd);
            builder.environment().putAll(System.getenv());
            builder.redirectErrorStream(true);
            Process proc = builder.start();
            pid = ProcessUtils.getPid(proc);
            logger.info("sub process {} on behalf of job {}, start to run...", (Object)pid, (Object)jobId);
            EventBusFactory.getInstance().postSync(new ProcessStart(pid, jobId));
            int maxCommandLineOutputLength = KylinConfig.getInstanceFromEnv().getMaxCommandLineOutputLength();
            int headSize = maxCommandLineOutputLength / 2;
            StringBuilderHelper result = StringBuilderHelper.headTail(headSize, maxCommandLineOutputLength - headSize);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    result.append(line).append('\n');
                    if (logAppender != null) {
                        logAppender.log(line);
                    }
                    if (!Thread.currentThread().isInterrupted()) continue;
                    String msg = Arrays.toString(cmd) + " is interrupt";
                    logger.warn(msg);
                    throw new InterruptedException(msg);
                }
            }
            try {
                int exitCode = proc.waitFor();
                String b = result.toString();
                if (b.length() > 0x6400000) {
                    logger.info("[LESS_LIKELY_THINGS_HAPPENED]Sub process log larger than 100M");
                }
                CliCmdExecResult cliCmdExecResult = new CliCmdExecResult(exitCode, b, pid + "");
                return cliCmdExecResult;
            }
            catch (InterruptedException e) {
                try {
                    logger.warn("Thread is interrupted, cmd: {}, pid: {}", new Object[]{cmd, pid, e});
                    Thread.currentThread().interrupt();
                    throw e;
                }
                catch (Exception e2) {
                    throw new ShellException(e2);
                }
            }
        }
        finally {
            EventBusFactory.getInstance().postSync(new ProcessFinished(pid));
        }
    }

    public static class CliCmdExecResult {
        int code;
        String cmd;
        String processId;

        @Generated
        public CliCmdExecResult(int code, String cmd, String processId) {
            this.code = code;
            this.cmd = cmd;
            this.processId = processId;
        }

        @Generated
        public int getCode() {
            return this.code;
        }

        @Generated
        public void setCode(int code) {
            this.code = code;
        }

        @Generated
        public String getCmd() {
            return this.cmd;
        }

        @Generated
        public void setCmd(String cmd) {
            this.cmd = cmd;
        }

        @Generated
        public String getProcessId() {
            return this.processId;
        }

        @Generated
        public void setProcessId(String processId) {
            this.processId = processId;
        }
    }

    public static class JobKilled {
        String jobId;

        @Generated
        public void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Generated
        public String getJobId() {
            return this.jobId;
        }

        @Generated
        public JobKilled(String jobId) {
            this.jobId = jobId;
        }

        @Generated
        public String toString() {
            return "CliCommandExecutor.JobKilled(jobId=" + this.getJobId() + ")";
        }
    }

    public static class ProcessFinished {
        int pid;

        @Generated
        public void setPid(int pid) {
            this.pid = pid;
        }

        @Generated
        public int getPid() {
            return this.pid;
        }

        @Generated
        public ProcessFinished(int pid) {
            this.pid = pid;
        }

        @Generated
        public String toString() {
            return "CliCommandExecutor.ProcessFinished(pid=" + this.getPid() + ")";
        }
    }

    public static class ProcessStart {
        int pid;
        String jobId;

        @Generated
        public void setPid(int pid) {
            this.pid = pid;
        }

        @Generated
        public void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Generated
        public int getPid() {
            return this.pid;
        }

        @Generated
        public String getJobId() {
            return this.jobId;
        }

        @Generated
        public ProcessStart(int pid, String jobId) {
            this.pid = pid;
            this.jobId = jobId;
        }

        @Generated
        public String toString() {
            return "CliCommandExecutor.ProcessStart(pid=" + this.getPid() + ", jobId=" + this.getJobId() + ")";
        }
    }
}

