/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Logger;
import org.apache.kylin.common.util.SSHClientOutput;
import org.apache.kylin.common.util.StringBuilderHelper;
import org.apache.kylin.common.util.Unsafe;
import org.slf4j.LoggerFactory;

public class SSHClient {
    protected static final org.slf4j.Logger logger = LoggerFactory.getLogger(SSHClient.class);
    private String hostname;
    private int port;
    private String username;
    private String password;
    private String identityPath;

    public SSHClient(String hostname, int port, String username, String password) {
        this.hostname = hostname;
        this.username = username;
        this.port = port;
        if (password == null) {
            this.identityPath = "~/.ssh/id_rsa";
        } else if (new File(password).exists()) {
            this.identityPath = new File(password).getAbsolutePath();
            this.password = null;
        } else {
            this.password = password;
        }
    }

    public SSHClient(String hostname, int port, String username, String password, String identityPath) {
        this(hostname, port, username, password);
        if (!StringUtils.isEmpty((CharSequence)identityPath)) {
            this.identityPath = identityPath;
        }
    }

    public void scpFileToRemote(String localFile, String remoteTargetDirectory) throws Exception {
        FileInputStream fis = null;
        try {
            int len;
            logger.info("SCP file " + localFile + " to " + remoteTargetDirectory);
            Session session = this.newJSchSession();
            session.connect();
            boolean ptimestamp = false;
            String command = "scp " + (ptimestamp ? "-p" : "") + " -t " + remoteTargetDirectory;
            Channel channel = session.openChannel("exec");
            ((ChannelExec)channel).setCommand(command);
            OutputStream out = channel.getOutputStream();
            InputStream in = channel.getInputStream();
            channel.connect();
            if (this.checkAck(in) != 0) {
                Unsafe.systemExit(0);
            }
            File _lfile = new File(localFile);
            if (ptimestamp) {
                command = "T " + _lfile.lastModified() / 1000L + " 0";
                command = command + " " + _lfile.lastModified() / 1000L + " 0\n";
                out.write(command.getBytes(Charset.defaultCharset()));
                out.flush();
                if (this.checkAck(in) != 0) {
                    throw new Exception("Error in checkAck()");
                }
            }
            long filesize = _lfile.length();
            command = "C0644 " + filesize + " ";
            command = localFile.lastIndexOf("/") > 0 ? command + localFile.substring(localFile.lastIndexOf("/") + 1) : (localFile.lastIndexOf(File.separator) > 0 ? command + localFile.substring(localFile.lastIndexOf(File.separator) + 1) : command + localFile);
            command = command + "\n";
            out.write(command.getBytes(Charset.defaultCharset()));
            out.flush();
            if (this.checkAck(in) != 0) {
                throw new Exception("Error in checkAck()");
            }
            fis = new FileInputStream(localFile);
            byte[] buf = new byte[1024];
            while ((len = fis.read(buf, 0, buf.length)) > 0) {
                out.write(buf, 0, len);
            }
            fis.close();
            fis = null;
            buf[0] = 0;
            out.write(buf, 0, 1);
            out.flush();
            if (this.checkAck(in) != 0) {
                throw new Exception("Error in checkAck()");
            }
            out.close();
            channel.disconnect();
            session.disconnect();
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)fis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scpRemoteFileToLocal(String remoteFile, String localTargetDirectory) throws Exception {
        InputStream fis = null;
        try {
            int c;
            logger.info("SCP file " + remoteFile + " to " + localTargetDirectory);
            Session session = this.newJSchSession();
            session.connect();
            String prefix = null;
            if (new File(localTargetDirectory).isDirectory()) {
                prefix = localTargetDirectory + File.separator;
            }
            String command = "scp -p -f " + remoteFile;
            Channel channel = session.openChannel("exec");
            ((ChannelExec)channel).setCommand(command);
            OutputStream out = channel.getOutputStream();
            InputStream in = channel.getInputStream();
            channel.connect();
            byte[] buf = new byte[1024];
            buf[0] = 0;
            out.write(buf, 0, 1);
            out.flush();
            while ((c = this.checkAck(in)) == 84) {
                long modTime = this.getModifyTime(out, in, buf);
                while ((c = this.checkAck(in)) != 67) {
                }
                long fileSize = 0L;
                fileSize = this.getFilesize(out, in, buf, fileSize);
                int i = 0;
                while (true) {
                    in.read(buf, i, 1);
                    if (buf[i] == 10) break;
                    ++i;
                }
                String file = new String(buf, 0, i, Charset.defaultCharset());
                logger.info("file-size=" + fileSize + ", file=" + file);
                FileOutputStream fos = new FileOutputStream(prefix == null ? remoteFile : prefix + file);
                Throwable throwable = null;
                try {
                    File tempFile;
                    int foo;
                    do {
                        foo = (long)buf.length < fileSize ? buf.length : (int)fileSize;
                        if ((foo = in.read(buf, 0, foo)) < 0) break;
                        fos.write(buf, 0, foo);
                    } while ((fileSize -= (long)foo) != 0L);
                    if (this.checkAck(in) != 0) {
                        Unsafe.systemExit(0);
                    }
                    if (!(tempFile = new File(prefix + file)).setLastModified(modTime * 1000L)) {
                        logger.warn("update {} modify time failed", (Object)file);
                    }
                    buf[0] = 0;
                    out.write(buf, 0, 1);
                    out.flush();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fos == null) continue;
                    if (throwable != null) {
                        try {
                            fos.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    fos.close();
                }
            }
            channel.disconnect();
            session.disconnect();
        }
        finally {
            IOUtils.closeQuietly(fis);
        }
    }

    private long getFilesize(OutputStream out, InputStream in, byte[] buf, long filesize) throws IOException {
        in.read(buf, 0, 5);
        while (in.read(buf, 0, 1) >= 0 && buf[0] != 32) {
            filesize = filesize * 10L + (long)(buf[0] - 48);
        }
        buf[0] = 0;
        out.write(buf, 0, 1);
        out.flush();
        return filesize;
    }

    private long getModifyTime(OutputStream out, InputStream in, byte[] buf) throws IOException {
        long modTime = 0L;
        while (in.read(buf, 0, 1) >= 0 && buf[0] != 32) {
            modTime = modTime * 10L + (long)(buf[0] - 48);
        }
        buf[0] = 0;
        out.write(buf, 0, 1);
        out.flush();
        return modTime;
    }

    public SSHClientOutput execCommand(String command) throws Exception {
        return this.execCommand(command, 7200, null);
    }

    public SSHClientOutput execCommand(String command, int timeoutSeconds, Logger logAppender) throws Exception {
        Channel channel;
        Session session;
        int exitCode;
        StringBuilderHelper text;
        block8: {
            logger.info("[" + this.username + "@" + this.hostname + "] Execute command: " + command);
            int maxCommandLineOutputLength = KylinConfig.getInstanceFromEnv().getMaxCommandLineOutputLength();
            text = StringBuilderHelper.headTail(maxCommandLineOutputLength / 2, maxCommandLineOutputLength - maxCommandLineOutputLength / 2);
            exitCode = -1;
            session = this.newJSchSession();
            session.connect();
            channel = session.openChannel("exec");
            ((ChannelExec)channel).setCommand(command);
            channel.setInputStream(null);
            ((ChannelExec)channel).setErrStream((OutputStream)System.err);
            InputStream in = channel.getInputStream();
            InputStream err = ((ChannelExec)channel).getErrStream();
            channel.connect();
            int timeout = timeoutSeconds;
            byte[] tmp = new byte[1024];
            while (true) {
                String line;
                int i;
                --timeout;
                while (in.available() > 0 && (i = in.read(tmp, 0, 1024)) >= 0) {
                    line = new String(tmp, 0, i, Charset.defaultCharset());
                    text.append(line);
                    if (logAppender == null) continue;
                    logAppender.log(line);
                }
                while (err.available() > 0 && (i = err.read(tmp, 0, 1024)) >= 0) {
                    line = new String(tmp, 0, i, Charset.defaultCharset());
                    text.append(line);
                    if (logAppender == null) continue;
                    logAppender.log(line);
                }
                if (channel.isClosed()) {
                    if (in.available() > 0) continue;
                    break block8;
                }
                Thread.sleep(1000L);
                if (timeout < 0) break;
            }
            throw new Exception("Remote command not finished within " + timeoutSeconds + " seconds.");
        }
        exitCode = channel.getExitStatus();
        logger.info("[" + this.username + "@" + this.hostname + "] Command exit-status: " + exitCode);
        channel.disconnect();
        session.disconnect();
        return new SSHClientOutput(exitCode, text.toString());
    }

    private Session newJSchSession() throws JSchException {
        JSch jsch = new JSch();
        if (this.identityPath != null) {
            jsch.addIdentity(this.identityPath);
        }
        Session session = jsch.getSession(this.username, this.hostname, this.port);
        if (this.password != null) {
            session.setPassword(this.password);
        }
        session.setConfig("StrictHostKeyChecking", "no");
        session.setConfig("PreferredAuthentications", "publickey,keyboard-interactive,password");
        return session;
    }

    private int checkAck(InputStream in) throws IOException {
        int b = in.read();
        if (b == 0) {
            return b;
        }
        if (b == -1) {
            return b;
        }
        if (b == 1 || b == 2) {
            int c;
            StringBuilder sb = new StringBuilder();
            do {
                c = in.read();
                sb.append((char)c);
            } while (c != 10);
            if (b == 1) {
                logger.error(sb.toString());
            }
            if (b == 2) {
                logger.error(sb.toString());
            }
        }
        return b;
    }
}

