/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import lombok.Generated;

public final class SerializeUtil {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] serialize(Object object) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(object);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new IllegalStateException("serialize failed", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object deserialize(byte[] bytes) {
        try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));){
            Object object = ois.readObject();
            return object;
        }
        catch (Exception e) {
            throw new IllegalStateException("deserialize failed", e);
        }
    }

    @Generated
    private SerializeUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

