/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.oas.mappers;

import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import springfox.documentation.schema.CompoundModelSpecification;
import springfox.documentation.schema.ModelKey;
import springfox.documentation.schema.ModelSpecification;
import springfox.documentation.schema.ReferenceModelSpecification;
import springfox.documentation.service.ModelNamesRegistry;

public class ModelSpecificationInheritanceDeterminer {
    private final ModelNamesRegistry namesRegistry;
    private final Map<ModelKey, Schema> parentLookup = new HashMap<ModelKey, Schema>();

    public ModelSpecificationInheritanceDeterminer(ModelNamesRegistry namesRegistry) {
        this.namesRegistry = namesRegistry;
        for (ModelSpecification each : namesRegistry.modelsByName().values()) {
            Collection subclasses = each.getCompound().map(CompoundModelSpecification::getSubclassReferences).orElse(new ArrayList());
            for (ReferenceModelSpecification children : subclasses) {
                this.toRefModel(each).ifPresent(rm -> this.parentLookup.put(children.getKey(), (Schema)rm));
            }
        }
    }

    private Optional<Schema> toRefModel(ModelSpecification each) {
        return each.key().flatMap(k -> this.namesRegistry.nameByKey((ModelKey)k).map(n -> new ObjectSchema().$ref((String)n).type(null)));
    }

    public Optional<Schema> parent(ModelSpecification source) {
        return source.key().map(this.parentLookup::get);
    }
}

