/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.http.codec.DecoderHttpMessageReader;
import org.springframework.http.codec.EncoderHttpMessageWriter;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.codec.json.Jackson2CodecSupport;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.http.codec.support.DefaultServerCodecConfigurer;
import springfox.documentation.schema.configuration.ObjectMapperConfigured;

public class WebFluxObjectMapperConfigurer
implements BeanPostProcessor,
ApplicationEventPublisherAware {
    private ApplicationEventPublisher applicationEventPublisher;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof Jackson2CodecSupport) {
            Jackson2CodecSupport encoder = (Jackson2CodecSupport)bean;
            this.fireObjectMapperConfiguredEvent(encoder.getObjectMapper());
        }
        if (bean instanceof DefaultServerCodecConfigurer) {
            List readers = ((DefaultServerCodecConfigurer)bean).getReaders();
            for (HttpMessageReader reader : readers) {
                Decoder decoder;
                if (!(reader instanceof DecoderHttpMessageReader) || !((decoder = ((DecoderHttpMessageReader)reader).getDecoder()) instanceof Jackson2JsonDecoder)) continue;
                this.fireObjectMapperConfiguredEvent(((Jackson2JsonDecoder)decoder).getObjectMapper());
                return bean;
            }
            List writers = ((DefaultServerCodecConfigurer)bean).getWriters();
            for (HttpMessageWriter writer : writers) {
                Encoder encoder;
                if (!(writer instanceof EncoderHttpMessageWriter) || !((encoder = ((EncoderHttpMessageWriter)writer).getEncoder()) instanceof Jackson2JsonEncoder)) continue;
                this.fireObjectMapperConfiguredEvent(((Jackson2JsonEncoder)encoder).getObjectMapper());
                return bean;
            }
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    private void fireObjectMapperConfiguredEvent(ObjectMapper objectMapper) {
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new ObjectMapperConfigured(this, objectMapper));
    }
}

